/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.DataCell;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.maps.Table3D;
import com.romraider.swing.TableFrame;
import com.romraider.util.SettingsManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class TableToolBar
extends JToolBar
implements MouseListener,
ItemListener,
ActionListener {
    private static final long serialVersionUID = 8697645329367637930L;
    private static final Logger LOGGER = Logger.getLogger(TableToolBar.class);
    private final JButton incrementFine = new JButton();
    private final JButton decrementFine = new JButton();
    private final JButton incrementCoarse = new JButton();
    private final JButton decrementCoarse = new JButton();
    private final JButton enable3d = new JButton();
    private final JButton colorCells = new JButton();
    private final JButton refreshCompare = new JButton();
    private final JButton setValue = new JButton("Set");
    private final JButton multiply = new JButton("Mul");
    private final JFormattedTextField incrementByFine = new JFormattedTextField(new DecimalFormat("#.####"));
    private final JFormattedTextField incrementByCoarse = new JFormattedTextField(new DecimalFormat("#.####"));
    private final JFormattedTextField setValueText = new JFormattedTextField(new DecimalFormat("#.####"));
    private final JComboBox scaleSelection = new JComboBox();
    private final JPanel liveDataPanel = new JPanel();
    private final JLabel liveDataValue = new JLabel();
    private final URL incrementFineImage = this.getClass().getResource("/graphics/icon-incfine.png");
    private final URL decrementFineImage = this.getClass().getResource("/graphics/icon-decfine.png");
    private final URL incrementCoarseImage = this.getClass().getResource("/graphics/icon-inccoarse.png");
    private final URL decrementCoarseImage = this.getClass().getResource("/graphics/icon-deccoarse.png");
    private final URL enable3dImage = this.getClass().getResource("/graphics/3d_render.png");
    private final URL colorCellImage = this.getClass().getResource("/graphics/icon-palette.png");
    private final URL refreshCompareImage = this.getClass().getResource("/graphics/table_refresh.png");
    private final TitledBorder toolbarBorder = BorderFactory.createTitledBorder("Table Tools");
    private Table selectedTable = null;

    public TableToolBar() {
        super("Table Tools");
        this.setFloatable(true);
        this.setRollover(true);
        FlowLayout toolBarLayout = new FlowLayout(0, 0, 0);
        this.setLayout(toolBarLayout);
        this.setBorder(this.toolbarBorder);
        this.updateIcons();
        JPanel finePanel = new JPanel();
        finePanel.add(this.incrementFine);
        finePanel.add(this.decrementFine);
        finePanel.add(this.incrementByFine);
        this.add(finePanel);
        finePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)));
        JPanel coarsePanel = new JPanel();
        coarsePanel.add(this.incrementCoarse);
        coarsePanel.add(this.decrementCoarse);
        coarsePanel.add(this.incrementByCoarse);
        this.add(coarsePanel);
        coarsePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.red)));
        JPanel setValuePanel = new JPanel();
        setValuePanel.add(this.setValueText);
        setValuePanel.add(this.setValue);
        setValuePanel.add(this.multiply);
        this.add(setValuePanel);
        setValuePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.green)));
        this.colorCells.setEnabled(false);
        this.refreshCompare.setEnabled(false);
        this.enable3d.setEnabled(false);
        JPanel otherPanel = new JPanel();
        otherPanel.add(this.colorCells);
        otherPanel.add(this.refreshCompare);
        otherPanel.add(this.enable3d);
        this.add(otherPanel);
        JPanel scaleSelectionPanel = new JPanel();
        scaleSelectionPanel.add(this.scaleSelection);
        this.add(scaleSelectionPanel);
        this.incrementFine.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.decrementFine.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.incrementCoarse.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.decrementCoarse.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.enable3d.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.setValue.setPreferredSize(new Dimension(33, 23));
        this.setValue.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.multiply.setPreferredSize(new Dimension(33, 23));
        this.multiply.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.colorCells.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.refreshCompare.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.scaleSelection.setPreferredSize(new Dimension(80, 23));
        this.incrementByFine.setAlignmentX(0.5f);
        this.incrementByFine.setAlignmentY(0.5f);
        this.incrementByFine.setPreferredSize(new Dimension(45, 23));
        this.incrementByCoarse.setAlignmentX(0.5f);
        this.incrementByCoarse.setAlignmentY(0.5f);
        this.incrementByCoarse.setPreferredSize(new Dimension(45, 23));
        this.setValueText.setAlignmentX(0.5f);
        this.setValueText.setAlignmentY(0.5f);
        this.setValueText.setPreferredSize(new Dimension(45, 23));
        this.incrementFine.setToolTipText("Increment Value (Fine)");
        this.decrementFine.setToolTipText("Decrement Value (Fine)");
        this.incrementCoarse.setToolTipText("Increment Value (Coarse)");
        this.decrementCoarse.setToolTipText("Decrement Value (Coarse)");
        this.enable3d.setToolTipText("Render data in 3d");
        this.setValue.setToolTipText("Set Absolute Value");
        this.setValueText.setToolTipText("Set Absolute Value");
        this.incrementByFine.setToolTipText("Fine Value Adjustment");
        this.incrementByCoarse.setToolTipText("Coarse Value Adjustment");
        this.multiply.setToolTipText("Multiply Value");
        this.colorCells.setToolTipText("Color Table Cells");
        this.refreshCompare.setToolTipText("Refresh Table Compare");
        this.incrementFine.addMouseListener(this);
        this.decrementFine.addMouseListener(this);
        this.incrementCoarse.addMouseListener(this);
        this.decrementCoarse.addMouseListener(this);
        this.enable3d.addMouseListener(this);
        this.setValue.addMouseListener(this);
        this.multiply.addMouseListener(this);
        this.scaleSelection.addItemListener(this);
        this.colorCells.addMouseListener(this);
        this.refreshCompare.addMouseListener(this);
        AbstractAction enterAction = new AbstractAction(){
            private static final long serialVersionUID = -6008026264821746092L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame selectedFrame = ECUEditorManager.getECUEditor().getRightPanel().getSelectedFrame();
                if (selectedFrame == null || !(selectedFrame instanceof TableFrame)) {
                    return;
                }
                TableFrame frame = (TableFrame)selectedFrame;
                frame.toFront();
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                frame.requestFocusInWindow();
                TableToolBar.this.setValue(frame.getTable());
            }
        };
        InputMap im = this.getInputMap(2);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "enterAction");
        this.getActionMap().put(im.get(enter), enterAction);
        this.add(this.liveDataPanel);
        this.incrementFine.getInputMap().put(enter, "enterAction");
        this.decrementFine.getInputMap().put(enter, "enterAction");
        this.incrementCoarse.getInputMap().put(enter, "enterAction");
        this.decrementCoarse.getInputMap().put(enter, "enterAction");
        this.incrementByFine.getInputMap().put(enter, "enterAction");
        this.incrementByCoarse.getInputMap().put(enter, "enterAction");
        this.setValueText.getInputMap().put(enter, "enterAction");
        this.setValue.getInputMap().put(enter, "enterAction");
        this.setEnabled(true);
    }

    public void updateIcons() {
        Settings settings = SettingsManager.getSettings();
        this.incrementFine.setIcon(this.rescaleImageIcon(new ImageIcon(this.incrementFineImage), settings.getTableIconScale()));
        this.decrementFine.setIcon(this.rescaleImageIcon(new ImageIcon(this.decrementFineImage), settings.getTableIconScale()));
        this.incrementCoarse.setIcon(this.rescaleImageIcon(new ImageIcon(this.incrementCoarseImage), settings.getTableIconScale()));
        this.decrementCoarse.setIcon(this.rescaleImageIcon(new ImageIcon(this.decrementCoarseImage), settings.getTableIconScale()));
        this.enable3d.setIcon(this.rescaleImageIcon(new ImageIcon(this.enable3dImage), settings.getTableIconScale()));
        this.colorCells.setIcon(this.rescaleImageIcon(new ImageIcon(this.colorCellImage), settings.getTableIconScale()));
        this.refreshCompare.setIcon(this.rescaleImageIcon(new ImageIcon(this.refreshCompareImage), settings.getTableIconScale()));
    }

    private ImageIcon rescaleImageIcon(ImageIcon imageIcon, int percentOfOriginal) {
        int height = imageIcon.getImage().getHeight(this);
        int newHeight = (int)((double)height * ((double)percentOfOriginal * 0.01));
        int width = imageIcon.getImage().getWidth(this);
        int newWidth = (int)((double)width * ((double)percentOfOriginal * 0.01));
        if (newHeight == 0 || newWidth == 0) {
            throw new IllegalStateException("rescale error: w " + width + "/" + newWidth + ", h " + height + "/" + newHeight);
        }
        imageIcon.setImage(imageIcon.getImage().getScaledInstance(newWidth, newHeight, 4));
        return imageIcon;
    }

    public Table getTable() {
        JInternalFrame frame = ECUEditorManager.getECUEditor().getRightPanel().getSelectedFrame();
        if (null == frame) {
            return null;
        }
        if (!(frame instanceof TableFrame)) {
            return null;
        }
        return ((TableFrame)frame).getTable();
    }

    @Override
    public void setBorder(Border border) {
        if (SettingsManager.getSettings().isShowTableToolbarBorder()) {
            super.setBorder(this.toolbarBorder);
        } else {
            super.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void updateTableToolBar() {
        this.updateTableToolBar(this.getTable());
    }

    public void updateTableToolBar(Table selectedTable) {
        if (selectedTable == null && this.selectedTable == null) {
            return;
        }
        if (selectedTable != null && this.selectedTable != null && this.selectedTable.equals(selectedTable)) {
            return;
        }
        this.selectedTable = selectedTable;
        this.setBorder(this.toolbarBorder);
        if (null == selectedTable) {
            this.toggleTableToolBar(selectedTable);
            return;
        }
        this.updateToolbarIncrementDecrementValues();
        this.enable3d.setEnabled(selectedTable.getType() == 3);
        this.setScales(selectedTable.getScales());
        if (null == selectedTable.getCurrentScale()) {
            this.scaleSelection.setSelectedItem("Default");
        } else {
            this.scaleSelection.setSelectedItem(selectedTable.getCurrentScale().getName());
        }
        this.toggleTableToolBar(selectedTable);
    }

    private void updateToolbarIncrementDecrementValues() {
        if (null == this.selectedTable) {
            return;
        }
        double fineIncrement = 0.0;
        double coarseIncrement = 0.0;
        try {
            fineIncrement = Math.abs(this.selectedTable.getCurrentScale().getFineIncrement());
            coarseIncrement = Math.abs(this.selectedTable.getCurrentScale().getCoarseIncrement());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.incrementByFine.setValue(fineIncrement);
        this.incrementByCoarse.setValue(coarseIncrement);
    }

    private void toggleTableToolBar(Table currentTable) {
        boolean enabled;
        String newTitle = "";
        if (null == currentTable) {
            enabled = false;
        } else {
            Table1D cur1DTable;
            newTitle = currentTable instanceof Table1D ? ((cur1DTable = (Table1D)currentTable).isAxis() ? cur1DTable.getAxisParent().getName() + " (" + cur1DTable.getName() + ")" : currentTable.getName()) : currentTable.getName();
            enabled = true;
        }
        this.toolbarBorder.setTitle(newTitle);
        this.incrementFine.setEnabled(enabled);
        this.decrementFine.setEnabled(enabled);
        this.incrementCoarse.setEnabled(enabled);
        this.decrementCoarse.setEnabled(enabled);
        this.setValue.setEnabled(enabled);
        this.multiply.setEnabled(enabled);
        this.incrementByFine.setEnabled(enabled);
        this.incrementByCoarse.setEnabled(enabled);
        this.setValueText.setEnabled(enabled);
        this.scaleSelection.setEnabled(enabled);
        this.liveDataValue.setEnabled(enabled);
        this.colorCells.setEnabled(enabled);
        this.refreshCompare.setEnabled(enabled);
        if (null != currentTable && currentTable.getType() == 3 && enabled) {
            this.enable3d.setEnabled(true);
        } else {
            this.enable3d.setEnabled(false);
        }
        if (null != currentTable && null != currentTable.getCompareTable() && enabled) {
            this.refreshCompare.setEnabled(true);
        } else {
            this.refreshCompare.setEnabled(false);
        }
        if (null == currentTable || !currentTable.isLiveDataSupported() || enabled) {
            // empty if block
        }
        if (null != currentTable && currentTable.isStaticDataTable()) {
            if (enabled) {
                this.scaleSelection.setEnabled(true);
            } else {
                this.scaleSelection.setEnabled(false);
            }
            this.colorCells.setEnabled(false);
            this.refreshCompare.setEnabled(false);
            this.incrementFine.setEnabled(false);
            this.decrementFine.setEnabled(false);
            this.incrementCoarse.setEnabled(false);
            this.decrementCoarse.setEnabled(false);
            this.incrementByFine.setEnabled(false);
            this.incrementByCoarse.setEnabled(false);
            this.setValue.setEnabled(false);
            this.setValueText.setEnabled(false);
            this.multiply.setEnabled(false);
            this.enable3d.setEnabled(false);
        }
        this.repaint();
    }

    public void setScales(Vector<Scale> scales) {
        this.scaleSelection.removeItemListener(this);
        this.scaleSelection.removeAllItems();
        for (Scale scale : scales) {
            this.scaleSelection.addItem(scale.getName());
        }
        this.scaleSelection.addItemListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        if (e.getSource() == this.incrementCoarse) {
            this.incrementCoarse(curTable);
        } else if (e.getSource() == this.decrementCoarse) {
            this.decrementCoarse(curTable);
        } else if (e.getSource() == this.enable3d) {
            this.enable3d(curTable);
        } else if (e.getSource() == this.incrementFine) {
            this.incrementFine(curTable);
        } else if (e.getSource() == this.decrementFine) {
            this.decrementFine(curTable);
        } else if (e.getSource() == this.multiply) {
            this.multiply(curTable);
        } else if (e.getSource() == this.setValue) {
            this.setValue(curTable);
        } else if (e.getSource() == this.colorCells) {
            this.colorCells(curTable);
        } else if (e.getSource() == this.refreshCompare) {
            this.refreshCompare(curTable);
        }
    }

    public void setValue(Table currentTable) {
        currentTable.setRealValue(this.setValueText.getText());
    }

    public void multiply() {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        this.multiply(curTable);
    }

    public void multiply(Table currentTable) {
        try {
            currentTable.multiply(Double.parseDouble(this.setValueText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void incrementFine() {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        this.incrementFine(curTable);
    }

    public void incrementFine(Table currentTable) {
        currentTable.increment(Double.parseDouble(String.valueOf(this.incrementByFine.getValue())));
    }

    public void decrementFine() {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        this.decrementFine(curTable);
    }

    public void decrementFine(Table currentTable) {
        currentTable.increment(0.0 - Double.parseDouble(String.valueOf(this.incrementByFine.getValue())));
    }

    public void incrementCoarse() {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        this.incrementCoarse(curTable);
    }

    public void incrementCoarse(Table currentTable) {
        currentTable.increment(Double.parseDouble(String.valueOf(this.incrementByCoarse.getValue())));
    }

    public void decrementCoarse() {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        this.decrementCoarse(curTable);
    }

    public void decrementCoarse(Table currentTable) {
        currentTable.increment(0.0 - Double.parseDouble(String.valueOf(this.incrementByCoarse.getValue())));
    }

    public void enable3d(Table currentTable) {
        int rowCount = 0;
        int valueCount = 0;
        Vector<float[]> graphValues = new Vector<float[]>();
        graphValues.clear();
        if (currentTable.getType() == 3) {
            Table3D table3d = (Table3D)currentTable;
            DataCell[][] tableData = table3d.get3dData();
            valueCount = tableData.length;
            DataCell[] dataRow = tableData[0];
            rowCount = dataRow.length;
            for (int j = rowCount - 1; j >= 0; --j) {
                float[] rowValues = new float[valueCount];
                for (int i = 0; i < valueCount; ++i) {
                    DataCell theCell = tableData[i][j];
                    rowValues[i] = (float)theCell.getRealValue();
                }
                graphValues.add(rowValues);
            }
            Table1D xAxisTable1D = table3d.getXAxis();
            Table1D yAxisTable1D = table3d.getYAxis();
            DataCell[] dataCells = xAxisTable1D.getData();
            int length = dataCells.length;
            double[] xValues = new double[length];
            for (int i = 0; i < length; ++i) {
                xValues[i] = dataCells[i].getRealValue();
            }
            dataCells = yAxisTable1D.getData();
            length = dataCells.length;
            double[] yValues = new double[length];
            for (int i = 0; i < length; ++i) {
                double theValue = dataCells[i].getRealValue();
                BigDecimal finalRoundedValue = new BigDecimal(theValue).setScale(2, 4);
                yValues[i] = finalRoundedValue.doubleValue();
            }
            String xLabel = table3d.getXAxis().getName();
            String zLabel = table3d.getYAxis().getName();
            String yLabel = table3d.getCategory();
            table3d.calcCellRanges();
            double maxV = table3d.getMaxReal();
            double minV = table3d.getMinReal();
            LOGGER.debug("Scale: " + maxV + "," + minV);
            throw new UnsupportedOperationException();
        }
    }

    public void colorCells(Table currentTable) {
        currentTable.colorCells();
    }

    public void refreshCompare(Table currentTable) {
        currentTable.populateCompareValues(currentTable.getCompareTable());
    }

    public void setCoarseValue(double input) {
        this.incrementByCoarse.setText(String.valueOf(input));
        try {
            this.incrementByCoarse.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setFineValue(double input) {
        this.incrementByFine.setText(String.valueOf(input));
        try {
            this.incrementByFine.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void focusSetValue(char input) {
        this.setValueText.requestFocus();
        this.setValueText.setText(String.valueOf(input));
    }

    public void setInputMap(InputMap im) {
        this.incrementFine.setInputMap(0, im);
        this.decrementFine.setInputMap(0, im);
        this.incrementCoarse.setInputMap(0, im);
        this.decrementCoarse.setInputMap(0, im);
        this.setValue.setInputMap(0, im);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        if (e.getSource() == this.scaleSelection) {
            try {
                curTable.setScaleByName((String)this.scaleSelection.getSelectedItem());
                this.updateToolbarIncrementDecrementValues();
            }
            catch (NameNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
    }

    public void setLiveDataValue(String value) {
        this.liveDataValue.setText(value);
    }

    public void newGraphData(int x, int z, float value) {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        if (curTable.getType() == 3) {
            Table3D table3d = (Table3D)curTable;
            table3d.selectCellAt(x, table3d.getSizeY() - z - 1);
            table3d.setRealValue(String.valueOf(value));
        }
    }

    public void selectStateChange(int x, int z, boolean value) {
        Table curTable = this.getSelectedTable();
        if (null == curTable) {
            return;
        }
        if (curTable.getType() == 3) {
            if (value) {
                Table3D table3d = (Table3D)curTable;
                table3d.selectCellAtWithoutClear(x, table3d.getSizeY() - z - 1);
            } else {
                Table3D table3d = (Table3D)curTable;
                table3d.deSelectCellAt(x, table3d.getSizeY() - z - 1);
            }
        }
    }

    public Table getSelectedTable() {
        return this.selectedTable;
    }
}

