/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

import java.io.File;

public final class FormatFilename {
    private static final String separator = System.getProperty("file.separator");

    private FormatFilename() {
    }

    public static final String getShortName(File file) {
        String filePath = file.getAbsolutePath();
        if (filePath.length() > 45) {
            filePath = FormatFilename.getShortName(filePath);
        }
        return filePath;
    }

    public static final String getShortName(String filePath) {
        String regex = separator;
        if (separator.equals("\\")) {
            regex = "\\" + separator;
        }
        String[] filePathParts = filePath.split(regex);
        String logFileName = filePath;
        if (filePathParts.length > 3) {
            logFileName = String.format("%s%s%s...%s%s%s%s", filePathParts[0], separator, filePathParts[1].substring(0, Math.min(4, filePathParts[1].length())), separator, filePathParts[filePathParts.length - 2], separator, filePathParts[filePathParts.length - 1]);
        }
        return logFileName;
    }
}

