/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

public final class HexUtil {
    private HexUtil() {
    }

    public static String asHex(byte b) {
        return HexUtil.asHex(new byte[]{b});
    }

    public static String asHex(byte[] in) {
        return HexUtil.bytesToHex(in).toUpperCase();
    }

    public static byte[] asBytes(String hex) {
        if (hex.indexOf(32) >= 0) {
            hex = hex.replaceAll(" ", "");
        }
        if (hex.startsWith("0x")) {
            hex = hex.substring(2);
        }
        return HexUtil.hexToBytes(hex);
    }

    public static String bytesToHex(byte[] bs, int off, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        HexUtil.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    public static void bytesToHexAppend(byte[] bs, int off, int length, StringBuffer sb) {
        sb.ensureCapacity(sb.length() + length * 2);
        for (int i = off; i < off + length && i < bs.length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
    }

    public static String bytesToHex(byte[] bs) {
        return HexUtil.bytesToHex(bs, 0, bs.length);
    }

    public static byte[] hexToBytes(String s) {
        return HexUtil.hexToBytes(s, 0);
    }

    public static byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtil.hexToBytes(s, bs, off);
        return bs;
    }

    public static void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if (slen % 2 != 0) {
            s = '0' + s;
        }
        if (out.length < off + slen / 2) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + "<" + off + slen / 2 + ")");
        }
        for (int i = 0; i < slen; i += 2) {
            byte b1 = (byte)Character.digit(s.charAt(i), 16);
            byte b2 = (byte)Character.digit(s.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException();
            }
            out[off + i / 2] = (byte)(b1 << 4 | b2);
        }
    }

    public static int hexToInt(String input) {
        if (input.length() > 2 && input.substring(0, 2).equalsIgnoreCase("0x")) {
            return Integer.parseInt(input.substring(2), 16);
        }
        return Integer.parseInt(input, 16);
    }

    public static String intToHexString(int input) {
        return "0x" + Integer.toHexString(input).toUpperCase();
    }
}

