/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

import java.util.Collection;
import java.util.Map;

public final class ParamChecker {
    private ParamChecker() {
    }

    public static void checkNotNull(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException("Parameter " + paramName + " must not be null");
        }
    }

    public static void checkNotNull(Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            ParamChecker.checkNotNull(params[i], "arg" + i);
        }
    }

    public static void checkNotNullOrEmpty(String param, String paramName) {
        if (ParamChecker.isNullOrEmpty(param)) {
            throw new IllegalArgumentException("Parameter " + paramName + " must not be null or empty");
        }
    }

    public static void checkNotNullOrEmpty(Object[] param, String paramName) {
        if (param == null || param.length == 0) {
            throw new IllegalArgumentException("Parameter " + paramName + " must not be null or empty");
        }
    }

    public static void checkNotNullOrEmpty(Collection<?> param, String paramName) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Parameter " + paramName + " must not be null or empty");
        }
    }

    public static void checkNotNullOrEmpty(Map<?, ?> param, String paramName) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Parameter " + paramName + " must not be null or empty");
        }
    }

    public static void checkGreaterThanZero(int param, String paramName) {
        if (param <= 0) {
            throw new IllegalArgumentException("Parameter " + paramName + " must be > 0");
        }
    }

    public static void checkNotNullOrEmpty(byte[] param, String paramName) {
        if (param == null || param.length == 0) {
            throw new IllegalArgumentException("Parameter " + paramName + " must not be null or empty");
        }
    }

    public static void checkBit(int bit) {
        if (!ParamChecker.isValidBit(bit)) {
            throw new IllegalArgumentException("Bit must be between 0 and 7 inclusive.");
        }
    }

    public static boolean isNullOrEmpty(String param) {
        return param == null || param.length() == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> param) {
        return param == null || param.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> param) {
        return param == null || param.isEmpty();
    }

    public static boolean isValidBit(int bit) {
        return bit >= 0 && bit <= 7;
    }
}

