/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

import com.romraider.Settings;
import com.romraider.swing.JProgressPane;
import com.romraider.xml.DOMSettingsBuilder;
import com.romraider.xml.DOMSettingsUnmarshaller;
import com.rusefi.FileLog;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SettingsManager {
    private static final String SETTINGS_FILE = "/settings.xml";
    private static final String USER_HOME = System.getProperty("user.home") + "/.RomRaider";
    private static final String START_DIR = System.getProperty("user.dir");
    private static String settingsDir = USER_HOME;
    private static Settings settings = null;

    public static Settings getSettings() {
        if (null == settings) {
            settings = SettingsManager.load();
        }
        return settings;
    }

    private static Settings load() {
        Settings loadedSettings;
        try {
            FileInputStream settingsFileIn = null;
            try {
                File sf = new File(USER_HOME + SETTINGS_FILE);
                settingsFileIn = new FileInputStream(sf);
            }
            catch (Exception e) {
                File sf = new File(START_DIR + SETTINGS_FILE);
                settingsFileIn = new FileInputStream(sf);
                settingsDir = START_DIR;
            }
            InputSource src = new InputSource(settingsFileIn);
            DOMSettingsUnmarshaller domUms = new DOMSettingsUnmarshaller();
            DOMParser parser = new DOMParser();
            parser.parse(src);
            Document doc = parser.getDocument();
            loadedSettings = domUms.unmarshallSettings(doc.getDocumentElement());
        }
        catch (FileNotFoundException e) {
            FileLog.MAIN.logLine("Settings file not found. Using default settings.");
            loadedSettings = new Settings();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return loadedSettings;
    }

    public static void save(Settings newSettings) {
        SettingsManager.save(newSettings, new JProgressPane());
    }

    public static void save(Settings newSettings, JProgressPane progress) {
        DOMSettingsBuilder builder = new DOMSettingsBuilder();
        try {
            File newDir = new File(settingsDir);
            newDir.mkdir();
            File sf = new File(settingsDir + SETTINGS_FILE);
            builder.buildSettings(newSettings, sf, progress, "0.5.8 RC 1 for rusEfi");
            settings = newSettings;
        }
        catch (Exception e) {
            settings = SettingsManager.load();
            throw new RuntimeException(e);
        }
    }
}

