/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util.proxy;

import com.romraider.util.ParamChecker;
import com.romraider.util.proxy.Wrapper;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public final class TimerWrapper
implements Wrapper {
    private static final Logger LOGGER = Logger.getLogger(TimerWrapper.class);
    private final Object delegate;

    public TimerWrapper(Object delegate) {
        ParamChecker.checkNotNull(delegate);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        finally {
            long time = System.currentTimeMillis() - start;
            this.log(method, time);
        }
    }

    private void log(Method method, long time) {
        String c = this.delegate.getClass().getSimpleName();
        String m = method.getName();
        LOGGER.error("[TIMER] - " + c + "." + m + ": " + time + "ms");
    }
}

