/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMHelper {
    private DOMHelper() {
    }

    public static String unmarshallText(Node textNode) {
        StringBuffer buf = new StringBuffer();
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            buf.append(n.getNodeValue());
        }
        return buf.toString();
    }

    public static String unmarshallAttribute(Node node, String name, String defaultValue) {
        Node n = node.getAttributes().getNamedItem(name);
        return n != null ? n.getNodeValue() : defaultValue;
    }

    public static Double unmarshallAttribute(Node node, String name, double defaultValue) {
        return Double.parseDouble(DOMHelper.unmarshallAttribute(node, name, String.valueOf(defaultValue)));
    }

    public static int unmarshallAttribute(Node node, String name, int defaultValue) {
        return Integer.parseInt(DOMHelper.unmarshallAttribute(node, name, String.valueOf(defaultValue)));
    }

    public static boolean unmarshallAttribute(Node node, String name, boolean defaultValue) {
        return Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node, name, String.valueOf(defaultValue)));
    }
}

