/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import com.romraider.maps.DataCell;
import com.romraider.maps.Rom;
import com.romraider.maps.RomID;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.maps.Table2D;
import com.romraider.maps.Table3D;
import com.romraider.maps.TableSwitch;
import com.romraider.swing.DebugPanel;
import com.romraider.swing.JProgressPane;
import com.romraider.util.LogManager;
import com.romraider.util.ObjectCloner;
import com.romraider.util.SettingsManager;
import com.romraider.xml.DOMHelper;
import com.romraider.xml.InvalidTableNameException;
import com.romraider.xml.RomAttributeParser;
import com.romraider.xml.RomNotFoundException;
import com.romraider.xml.TableIsOmittedException;
import com.romraider.xml.TableNotFoundException;
import com.rusefi.Launcher;
import java.util.ArrayList;
import java.util.List;
import javax.management.modelmbean.XMLParseException;
import javax.naming.NameNotFoundException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMRomUnmarshaller {
    private static final Logger LOGGER = Logger.getLogger(DOMRomUnmarshaller.class);
    private JProgressPane progress = null;
    private final List<Scale> scales = new ArrayList<Scale>();

    public Rom unmarshallXMLDefinition(Node rootNode, byte[] romContent, JProgressPane progress) throws RomNotFoundException, XMLParseException, NameNotFoundException {
        Node n;
        int i;
        this.progress = progress;
        NodeList nodes = rootNode.getChildNodes();
        for (i = 0; i < nodes.getLength(); ++i) {
            n = nodes.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("scalingbase")) continue;
            this.scales.add(this.unmarshallScale(n, new Scale()));
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            n = nodes.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("rom")) continue;
            NodeList nodes2 = n.getChildNodes();
            for (int z = 0; z < nodes2.getLength(); ++z) {
                RomID romID;
                Node n2 = nodes2.item(z);
                if (n2.getNodeType() != 1 || !n2.getNodeName().equalsIgnoreCase("romid") || (romID = this.unmarshallRomID(n2, new RomID())).getInternalIdString().length() <= 0 || !DOMRomUnmarshaller.foundMatch(romID, romContent)) continue;
                Rom output = this.unmarshallRom(n, new Rom());
                output.getRomID().setRamOffset(output.getRomID().getFileSize() - romContent.length);
                return output;
            }
        }
        throw new RomNotFoundException();
    }

    public static boolean foundMatch(RomID romID, byte[] file) {
        String idString = romID.getInternalIdString();
        if (idString.length() > 2 && idString.substring(0, 2).equalsIgnoreCase("0x")) {
            try {
                idString = idString.substring(2);
                int[] romIDBytes = new int[idString.length() / 2];
                for (int i = 0; i < romIDBytes.length; ++i) {
                    if ((file[romID.getInternalIdAddress() + i] & 0xFF) == Integer.parseInt(idString.substring(i * 2, i * 2 + 2), 16)) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                LOGGER.warn("Error finding match", ex);
                return false;
            }
        }
        try {
            String ecuID = new String(file, romID.getInternalIdAddress(), romID.getInternalIdString().length());
            return DOMRomUnmarshaller.foundMatchByString(romID, ecuID);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean foundMatchByString(RomID romID, String ecuID) {
        try {
            return ecuID.equalsIgnoreCase(romID.getInternalIdString());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void main(String[] args) {
        LogManager.initDebugLogging();
        RomID romID = new RomID();
        romID.setInternalIdString("Asdfd");
        byte[] file = "Asdfd".getBytes();
        LOGGER.debug(DOMRomUnmarshaller.foundMatch(romID, file));
        file[0] = 1;
        file[1] = 1;
        file[2] = 1;
        file[3] = 1;
        LOGGER.debug(DOMRomUnmarshaller.foundMatch(romID, file));
        romID.setInternalIdString("0x010101");
        LOGGER.debug(DOMRomUnmarshaller.foundMatch(romID, file));
    }

    public Rom unmarshallRom(Node rootNode, Rom rom) throws XMLParseException, RomNotFoundException, NameNotFoundException {
        NodeList nodes = rootNode.getChildNodes();
        this.progress.update("Creating tables...", 15);
        if (!DOMHelper.unmarshallAttribute(rootNode, "base", "none").equalsIgnoreCase("none")) {
            rom = this.getBaseRom(rootNode.getParentNode(), DOMHelper.unmarshallAttribute(rootNode, "base", "none"), rom);
            rom.getRomID().setObsolete(false);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            int currProgress = (int)((double)i / (double)nodes.getLength() * 40.0);
            this.progress.update("Creating tables...", 10 + currProgress);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equalsIgnoreCase("romid")) {
                rom.setRomID(this.unmarshallRomID(n, rom.getRomID()));
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("table")) continue;
            Table table = null;
            try {
                table = rom.getTableByName(DOMHelper.unmarshallAttribute(n, "name", null));
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (InvalidTableNameException invalidTableNameException) {
                // empty catch block
            }
            try {
                table = this.unmarshallTable(n, table, rom);
                rom.addTable(table);
                continue;
            }
            catch (TableIsOmittedException ex) {
                if (table == null) continue;
                rom.removeTable(table);
                continue;
            }
            catch (XMLParseException ex) {
                LOGGER.error("Error unmarshalling rom", ex);
            }
        }
        return rom;
    }

    public Rom getBaseRom(Node rootNode, String xmlID, Rom rom) throws XMLParseException, RomNotFoundException, NameNotFoundException {
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("rom")) continue;
            NodeList nodes2 = n.getChildNodes();
            for (int z = 0; z < nodes2.getLength(); ++z) {
                RomID romID;
                Node n2 = nodes2.item(z);
                if (n2.getNodeType() != 1 || !n2.getNodeName().equalsIgnoreCase("romid") || !(romID = this.unmarshallRomID(n2, new RomID())).getXmlid().equalsIgnoreCase(xmlID)) continue;
                Rom returnrom = this.unmarshallRom(n, rom);
                returnrom.getRomID().setObsolete(false);
                return returnrom;
            }
        }
        throw new RomNotFoundException();
    }

    public RomID unmarshallRomID(Node romIDNode, RomID romID) {
        NodeList nodes = romIDNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equalsIgnoreCase("xmlid")) {
                romID.setXmlid(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("internalidaddress")) {
                romID.setInternalIdAddress(RomAttributeParser.parseHexString(DOMHelper.unmarshallText(n)));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("internalidstring")) {
                romID.setInternalIdString(DOMHelper.unmarshallText(n));
                if (romID.getInternalIdString() != null) continue;
                romID.setInternalIdString("");
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("caseid")) {
                romID.setCaseId(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("ecuid")) {
                romID.setEcuId(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("make")) {
                romID.setMake(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("market")) {
                romID.setMarket(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("model")) {
                romID.setModel(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("submodel")) {
                romID.setSubModel(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("transmission")) {
                romID.setTransmission(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("year")) {
                romID.setYear(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("flashmethod")) {
                romID.setFlashMethod(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("memmodel")) {
                romID.setMemModel(DOMHelper.unmarshallText(n));
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("filesize")) {
                romID.setFileSize(RomAttributeParser.parseFileSize(DOMHelper.unmarshallText(n)));
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("obsolete")) continue;
            romID.setObsolete(Boolean.parseBoolean(DOMHelper.unmarshallText(n)));
        }
        return romID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Table unmarshallTable(Node tableNode, Table table, Rom rom) throws XMLParseException, TableIsOmittedException, NameNotFoundException {
        if (DOMHelper.unmarshallAttribute(tableNode, "omit", "false").equalsIgnoreCase("true")) {
            throw new TableIsOmittedException();
        }
        if (!DOMHelper.unmarshallAttribute(tableNode, "base", "none").equalsIgnoreCase("none")) {
            try {
                table = (Table)ObjectCloner.deepCopy(rom.getTableByName(DOMHelper.unmarshallAttribute(tableNode, "base", "none")));
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (InvalidTableNameException invalidTableNameException) {
            }
            catch (NullPointerException ex) {
                JOptionPane.showMessageDialog(Launcher.getFrame(), new DebugPanel(ex, SettingsManager.getSettings().getSupportURL()), "Exception", 0);
            }
        }
        try {
            if (table.getType() >= 1) {
                // empty if block
            }
        }
        catch (NullPointerException ex) {
            String typeStr = DOMHelper.unmarshallAttribute(tableNode, "type", "unknown");
            if (typeStr.equalsIgnoreCase("3D")) {
                table = new Table3D();
            }
            if (typeStr.equalsIgnoreCase("2D")) {
                table = new Table2D();
            }
            if (typeStr.equalsIgnoreCase("1D") || typeStr.equalsIgnoreCase("X Axis") || typeStr.equalsIgnoreCase("Y Axis")) {
                table = new Table1D();
            }
            if (typeStr.equalsIgnoreCase("Static Y Axis") || typeStr.equalsIgnoreCase("Static X Axis")) {
                table = new Table1D();
            }
            if (!typeStr.equalsIgnoreCase("Switch")) {
                throw new XMLParseException("Error loading table, " + tableNode.getAttributes().getNamedItem("name"));
            }
            table = new TableSwitch();
        }
        table.setName(DOMHelper.unmarshallAttribute(tableNode, "name", table.getName()));
        table.setType(RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(tableNode, "type", String.valueOf(table.getType()))));
        if (DOMHelper.unmarshallAttribute(tableNode, "beforeram", "false").equalsIgnoreCase("true")) {
            table.setBeforeRam(true);
        }
        table.setCategory(DOMHelper.unmarshallAttribute(tableNode, "category", table.getCategory()));
        if (table.getStorageType() < 1) {
            table.setSignedData(RomAttributeParser.parseStorageDataSign(DOMHelper.unmarshallAttribute(tableNode, "storagetype", String.valueOf(table.getStorageType()))));
        }
        table.setStorageType(RomAttributeParser.parseStorageType(DOMHelper.unmarshallAttribute(tableNode, "storagetype", String.valueOf(table.getStorageType()))));
        table.setEndian(RomAttributeParser.parseEndian(DOMHelper.unmarshallAttribute(tableNode, "endian", String.valueOf(table.getEndian()))));
        table.setStorageAddress(RomAttributeParser.parseHexString(DOMHelper.unmarshallAttribute(tableNode, "storageaddress", String.valueOf(table.getStorageAddress()))));
        table.setDescription(DOMHelper.unmarshallAttribute(tableNode, "description", table.getDescription()));
        table.setDataSize(DOMHelper.unmarshallAttribute(tableNode, "sizey", DOMHelper.unmarshallAttribute(tableNode, "sizex", table.getDataSize())));
        table.setFlip(DOMHelper.unmarshallAttribute(tableNode, "flipy", DOMHelper.unmarshallAttribute(tableNode, "flipx", table.getFlip())));
        table.setUserLevel(DOMHelper.unmarshallAttribute(tableNode, "userlevel", table.getUserLevel()));
        table.setLocked(DOMHelper.unmarshallAttribute(tableNode, "locked", table.isLocked()));
        table.setLogParam(DOMHelper.unmarshallAttribute(tableNode, "logparam", table.getLogParam()));
        if (table.getType() == 3) {
            ((Table3D)table).setSwapXY(DOMHelper.unmarshallAttribute(tableNode, "swapxy", ((Table3D)table).getSwapXY()));
            ((Table3D)table).setFlipX(DOMHelper.unmarshallAttribute(tableNode, "flipx", ((Table3D)table).getFlipX()));
            ((Table3D)table).setFlipY(DOMHelper.unmarshallAttribute(tableNode, "flipy", ((Table3D)table).getFlipY()));
            ((Table3D)table).setSizeX(DOMHelper.unmarshallAttribute(tableNode, "sizex", ((Table3D)table).getSizeX()));
            ((Table3D)table).setSizeY(DOMHelper.unmarshallAttribute(tableNode, "sizey", ((Table3D)table).getSizeY()));
        }
        NodeList nodes = tableNode.getChildNodes();
        int i = 0;
        while (true) {
            block35: {
                Node n;
                block36: {
                    Table1D tempTable;
                    block37: {
                        if (i >= nodes.getLength()) {
                            return table;
                        }
                        n = nodes.item(i);
                        if (n.getNodeType() != 1) break block35;
                        if (!n.getNodeName().equalsIgnoreCase("table")) break block36;
                        if (table.getType() != 2) break block37;
                        if (RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(n, "type", "unknown")) == 5 || RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(n, "type", "unknown")) == 4) {
                            tempTable = (Table1D)this.unmarshallTable(n, ((Table2D)table).getAxis(), rom);
                            if (tempTable.getDataSize() != table.getDataSize()) {
                                tempTable.setDataSize(table.getDataSize());
                            }
                            tempTable.setData(((Table2D)table).getAxis().getData());
                            ((Table2D)table).setAxis(tempTable);
                        }
                        break block35;
                    }
                    if (table.getType() != 3) break block35;
                    if (RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(n, "type", "unknown")) == 4) {
                        tempTable = (Table1D)this.unmarshallTable(n, ((Table3D)table).getXAxis(), rom);
                        if (tempTable.getDataSize() != ((Table3D)table).getSizeX()) {
                            tempTable.setDataSize(((Table3D)table).getSizeX());
                        }
                        tempTable.setData(((Table3D)table).getXAxis().getData());
                        ((Table3D)table).setXAxis(tempTable);
                        break block35;
                    } else if (RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(n, "type", "unknown")) == 5) {
                        tempTable = (Table1D)this.unmarshallTable(n, ((Table3D)table).getYAxis(), rom);
                        if (tempTable.getDataSize() != ((Table3D)table).getSizeY()) {
                            tempTable.setDataSize(((Table3D)table).getSizeY());
                        }
                        tempTable.setData(((Table3D)table).getYAxis().getData());
                        ((Table3D)table).setYAxis(tempTable);
                    }
                    break block35;
                }
                if (n.getNodeName().equalsIgnoreCase("scaling")) {
                    Scale baseScale = table.getScale(DOMHelper.unmarshallAttribute(n, "name", "Default"));
                    table.addScale(this.unmarshallScale(n, baseScale));
                } else if (n.getNodeName().equalsIgnoreCase("data")) {
                    DataCell dataCell = new DataCell(table, DOMHelper.unmarshallText(n));
                    if (table instanceof Table1D) {
                        ((Table1D)table).addStaticDataCell(dataCell);
                    } else {
                        LOGGER.error("Error adding static data cell.");
                    }
                } else if (n.getNodeName().equalsIgnoreCase("description")) {
                    table.setDescription(DOMHelper.unmarshallText(n));
                } else if (n.getNodeName().equalsIgnoreCase("state")) {
                    ((TableSwitch)table).setValues(DOMHelper.unmarshallAttribute(n, "name", ""), DOMHelper.unmarshallAttribute(n, "data", "0.0"));
                }
            }
            ++i;
        }
    }

    private Scale unmarshallScale(Node scaleNode, Scale scale) {
        String base = DOMHelper.unmarshallAttribute(scaleNode, "base", "none");
        if (!base.equalsIgnoreCase("none")) {
            for (Scale scaleItem : this.scales) {
                if (!scaleItem.getName().equalsIgnoreCase(base)) continue;
                try {
                    scale = (Scale)ObjectCloner.deepCopy(scaleItem);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Launcher.getFrame(), new DebugPanel(ex, SettingsManager.getSettings().getSupportURL()), "Exception", 0);
                }
            }
        }
        scale.setName(DOMHelper.unmarshallAttribute(scaleNode, "name", "Default"));
        scale.setUnit(DOMHelper.unmarshallAttribute(scaleNode, "units", scale.getUnit()));
        scale.setExpression(DOMHelper.unmarshallAttribute(scaleNode, "expression", scale.getExpression()));
        scale.setByteExpression(DOMHelper.unmarshallAttribute(scaleNode, "to_byte", scale.getByteExpression()));
        scale.setFormat(DOMHelper.unmarshallAttribute(scaleNode, "format", "#"));
        scale.setMax(DOMHelper.unmarshallAttribute(scaleNode, "max", 0.0));
        scale.setMin(DOMHelper.unmarshallAttribute(scaleNode, "min", 0.0));
        scale.setCoarseIncrement(DOMHelper.unmarshallAttribute(scaleNode, "coarseincrement", DOMHelper.unmarshallAttribute(scaleNode, "increment", scale.getCoarseIncrement())));
        scale.setFineIncrement(DOMHelper.unmarshallAttribute(scaleNode, "fineincrement", scale.getFineIncrement()));
        return scale;
    }
}

