/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import com.romraider.Settings;
import com.romraider.swing.JProgressPane;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.imageio.metadata.IIOMetadataNode;

public final class DOMSettingsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSettings(Settings settings, File output, JProgressPane progress, String versionNumber) throws IOException {
        IIOMetadataNode settingsNode = new IIOMetadataNode("settings");
        progress.update("Saving window settings...", 15);
        settingsNode.appendChild(this.buildWindow(settings));
        progress.update("Saving file settings...", 30);
        settingsNode.appendChild(this.buildFiles(settings));
        progress.update("Saving options...", 45);
        settingsNode.appendChild(this.buildOptions(settings, versionNumber));
        progress.update("Saving display settings...", 60);
        settingsNode.appendChild(this.buildTableDisplay(settings));
        progress.update("Saving logger settings...", 75);
        settingsNode.appendChild(this.buildLogger(settings));
        progress.update("Saving table clipboard format settings...", 80);
        settingsNode.appendChild(this.buildTableClipboardFormat(settings));
        progress.update("Saving icon scale settings...", 85);
        settingsNode.appendChild(this.buildIcons(settings));
        OutputFormat of = new OutputFormat("XML", "ISO-8859-1", true);
        of.setIndent(1);
        of.setIndenting(true);
        progress.update("Writing to file...", 90);
        try (FileOutputStream fos = new FileOutputStream(output);){
            XMLSerializer serializer = new XMLSerializer(fos, of);
            serializer.serialize(settingsNode);
            fos.flush();
        }
    }

    private IIOMetadataNode buildWindow(Settings settings) {
        IIOMetadataNode windowSettings = new IIOMetadataNode("window");
        IIOMetadataNode maximized = new IIOMetadataNode("maximized");
        maximized.setAttribute("value", String.valueOf(settings.isWindowMaximized()));
        windowSettings.appendChild(maximized);
        IIOMetadataNode size = new IIOMetadataNode("size");
        size.setAttribute("x", String.valueOf((int)settings.getWindowSize().getHeight()));
        size.setAttribute("y", String.valueOf((int)settings.getWindowSize().getWidth()));
        windowSettings.appendChild(size);
        IIOMetadataNode location = new IIOMetadataNode("location");
        location.setAttribute("x", String.valueOf((int)settings.getWindowLocation().getX()));
        location.setAttribute("y", String.valueOf((int)settings.getWindowLocation().getY()));
        windowSettings.appendChild(location);
        IIOMetadataNode splitpane = new IIOMetadataNode("splitpane");
        splitpane.setAttribute("location", String.valueOf(settings.getSplitPaneLocation()));
        windowSettings.appendChild(splitpane);
        return windowSettings;
    }

    private IIOMetadataNode buildFiles(Settings settings) {
        IIOMetadataNode files = new IIOMetadataNode("files");
        IIOMetadataNode imageDir = new IIOMetadataNode("image_dir");
        imageDir.setAttribute("path", settings.getLastImageDir().getAbsolutePath());
        files.appendChild(imageDir);
        IIOMetadataNode repositoryDir = new IIOMetadataNode("repository-dir");
        repositoryDir.setAttribute("path", settings.getLastRepositoryDir().getAbsolutePath());
        files.appendChild(repositoryDir);
        Vector<File> defFiles = settings.getEcuDefinitionFiles();
        for (File defFile : defFiles) {
            IIOMetadataNode ecuDef = new IIOMetadataNode("ecudefinitionfile");
            ecuDef.setAttribute("name", defFile.getAbsolutePath());
            files.appendChild(ecuDef);
        }
        return files;
    }

    private IIOMetadataNode buildOptions(Settings settings, String versionNumber) {
        IIOMetadataNode options = new IIOMetadataNode("options");
        IIOMetadataNode obsoleteWarning = new IIOMetadataNode("obsoletewarning");
        obsoleteWarning.setAttribute("value", String.valueOf(settings.isObsoleteWarning()));
        options.appendChild(obsoleteWarning);
        IIOMetadataNode calcConflictWarning = new IIOMetadataNode("calcconflictwarning");
        calcConflictWarning.setAttribute("value", String.valueOf(settings.isCalcConflictWarning()));
        options.appendChild(calcConflictWarning);
        IIOMetadataNode debug = new IIOMetadataNode("debug");
        debug.setAttribute("value", String.valueOf(settings.isDebug()));
        options.appendChild(debug);
        IIOMetadataNode userLevel = new IIOMetadataNode("userlevel");
        userLevel.setAttribute("value", String.valueOf(settings.getUserLevel()));
        options.appendChild(userLevel);
        IIOMetadataNode tableClickCount = new IIOMetadataNode("tableclickcount");
        tableClickCount.setAttribute("value", String.valueOf(settings.getTableClickCount()));
        options.appendChild(tableClickCount);
        IIOMetadataNode tableClickBehavior = new IIOMetadataNode("tableclickbehavior");
        tableClickBehavior.setAttribute("value", String.valueOf(settings.getTableClickBehavior()));
        options.appendChild(tableClickBehavior);
        IIOMetadataNode version = new IIOMetadataNode("version");
        version.setAttribute("value", versionNumber);
        options.appendChild(version);
        IIOMetadataNode saveDebugTables = new IIOMetadataNode("savedebugtables");
        saveDebugTables.setAttribute("value", String.valueOf(settings.isSaveDebugTables()));
        options.appendChild(saveDebugTables);
        IIOMetadataNode displayHighTables = new IIOMetadataNode("displayhightables");
        displayHighTables.setAttribute("value", String.valueOf(settings.isDisplayHighTables()));
        options.appendChild(displayHighTables);
        IIOMetadataNode valueLimitWarning = new IIOMetadataNode("valuelimitwarning");
        valueLimitWarning.setAttribute("value", String.valueOf(settings.isValueLimitWarning()));
        options.appendChild(valueLimitWarning);
        IIOMetadataNode colorAxis = new IIOMetadataNode("coloraxis");
        colorAxis.setAttribute("value", String.valueOf(settings.isColorAxis()));
        options.appendChild(colorAxis);
        IIOMetadataNode showTableToolbarBorder = new IIOMetadataNode("showtabletoolbarborder");
        showTableToolbarBorder.setAttribute("value", String.valueOf(settings.isShowTableToolbarBorder()));
        options.appendChild(showTableToolbarBorder);
        IIOMetadataNode openRomExpanded = new IIOMetadataNode("openromexpanded");
        openRomExpanded.setAttribute("value", String.valueOf(settings.isOpenExpanded()));
        options.appendChild(openRomExpanded);
        IIOMetadataNode alwaysOpenTableAtZero = new IIOMetadataNode("alwaysopentableatzero");
        alwaysOpenTableAtZero.setAttribute("value", String.valueOf(settings.isAlwaysOpenTableAtZero()));
        options.appendChild(alwaysOpenTableAtZero);
        IIOMetadataNode defaultScale = new IIOMetadataNode("defaultscale");
        defaultScale.setAttribute("value", String.valueOf(settings.getDefaultScale()));
        options.appendChild(defaultScale);
        IIOMetadataNode scaleHeaderAndData = new IIOMetadataNode("scaleHeadersAndData");
        scaleHeaderAndData.setAttribute("value", String.valueOf(settings.isScaleHeadersAndData()));
        options.appendChild(scaleHeaderAndData);
        return options;
    }

    private IIOMetadataNode buildTableDisplay(Settings settings) {
        IIOMetadataNode tableDisplay = new IIOMetadataNode("tabledisplay");
        IIOMetadataNode font = new IIOMetadataNode("font");
        font.setAttribute("face", settings.getTableFont().getName());
        font.setAttribute("size", String.valueOf(settings.getTableFont().getSize()));
        font.setAttribute("decoration", String.valueOf(settings.getTableFont().getStyle()));
        tableDisplay.appendChild(font);
        IIOMetadataNode cellSize = new IIOMetadataNode("cellsize");
        cellSize.setAttribute("height", String.valueOf((int)settings.getCellSize().getHeight()));
        cellSize.setAttribute("width", String.valueOf((int)settings.getCellSize().getWidth()));
        tableDisplay.appendChild(cellSize);
        IIOMetadataNode colors = new IIOMetadataNode("colors");
        IIOMetadataNode max = new IIOMetadataNode("max");
        max.setAttribute("r", String.valueOf(settings.getMaxColor().getRed()));
        max.setAttribute("g", String.valueOf(settings.getMaxColor().getGreen()));
        max.setAttribute("b", String.valueOf(settings.getMaxColor().getBlue()));
        colors.appendChild(max);
        IIOMetadataNode min = new IIOMetadataNode("min");
        min.setAttribute("r", String.valueOf(settings.getMinColor().getRed()));
        min.setAttribute("g", String.valueOf(settings.getMinColor().getGreen()));
        min.setAttribute("b", String.valueOf(settings.getMinColor().getBlue()));
        colors.appendChild(min);
        IIOMetadataNode highlight = new IIOMetadataNode("highlight");
        highlight.setAttribute("r", String.valueOf(settings.getHighlightColor().getRed()));
        highlight.setAttribute("g", String.valueOf(settings.getHighlightColor().getGreen()));
        highlight.setAttribute("b", String.valueOf(settings.getHighlightColor().getBlue()));
        colors.appendChild(highlight);
        IIOMetadataNode select = new IIOMetadataNode("select");
        select.setAttribute("r", String.valueOf(settings.getSelectColor().getRed()));
        select.setAttribute("g", String.valueOf(settings.getSelectColor().getGreen()));
        select.setAttribute("b", String.valueOf(settings.getSelectColor().getBlue()));
        colors.appendChild(select);
        IIOMetadataNode increaseBorder = new IIOMetadataNode("increaseborder");
        increaseBorder.setAttribute("r", String.valueOf(settings.getIncreaseBorder().getRed()));
        increaseBorder.setAttribute("g", String.valueOf(settings.getIncreaseBorder().getGreen()));
        increaseBorder.setAttribute("b", String.valueOf(settings.getIncreaseBorder().getBlue()));
        colors.appendChild(increaseBorder);
        IIOMetadataNode decreaseBorder = new IIOMetadataNode("decreaseborder");
        decreaseBorder.setAttribute("r", String.valueOf(settings.getDecreaseBorder().getRed()));
        decreaseBorder.setAttribute("g", String.valueOf(settings.getDecreaseBorder().getGreen()));
        decreaseBorder.setAttribute("b", String.valueOf(settings.getDecreaseBorder().getBlue()));
        colors.appendChild(decreaseBorder);
        IIOMetadataNode axis = new IIOMetadataNode("axis");
        axis.setAttribute("r", String.valueOf(settings.getAxisColor().getRed()));
        axis.setAttribute("g", String.valueOf(settings.getAxisColor().getGreen()));
        axis.setAttribute("b", String.valueOf(settings.getAxisColor().getBlue()));
        colors.appendChild(axis);
        IIOMetadataNode warning = new IIOMetadataNode("warning");
        warning.setAttribute("r", String.valueOf(settings.getWarningColor().getRed()));
        warning.setAttribute("g", String.valueOf(settings.getWarningColor().getGreen()));
        warning.setAttribute("b", String.valueOf(settings.getWarningColor().getBlue()));
        colors.appendChild(warning);
        tableDisplay.appendChild(colors);
        return tableDisplay;
    }

    private IIOMetadataNode buildLogger(Settings settings) {
        IIOMetadataNode loggerSettings = new IIOMetadataNode("logger");
        loggerSettings.setAttribute("locale", settings.getLocale());
        IIOMetadataNode serial = new IIOMetadataNode("serial");
        serial.setAttribute("port", settings.getLoggerPortDefault());
        serial.setAttribute("refresh", String.valueOf(settings.getRefreshMode()));
        serial.setAttribute("ecuid", String.valueOf(settings.getDestinationId()));
        serial.setAttribute("fastpoll", String.valueOf(settings.isFastPoll()));
        loggerSettings.appendChild(serial);
        IIOMetadataNode protocol = new IIOMetadataNode("protocol");
        protocol.setAttribute("name", settings.getLoggerProtocol());
        protocol.setAttribute("transport", settings.getTransportProtocol());
        protocol.setAttribute("library", settings.getJ2534Device());
        loggerSettings.appendChild(protocol);
        IIOMetadataNode maximized = new IIOMetadataNode("maximized");
        maximized.setAttribute("value", String.valueOf(settings.isLoggerWindowMaximized()));
        loggerSettings.appendChild(maximized);
        IIOMetadataNode size = new IIOMetadataNode("size");
        size.setAttribute("x", String.valueOf((int)settings.getLoggerWindowSize().getHeight()));
        size.setAttribute("y", String.valueOf((int)settings.getLoggerWindowSize().getWidth()));
        size.setAttribute("divider", String.valueOf((int)settings.getDividerLocation()));
        loggerSettings.appendChild(size);
        IIOMetadataNode location = new IIOMetadataNode("location");
        location.setAttribute("x", String.valueOf((int)settings.getLoggerWindowLocation().getX()));
        location.setAttribute("y", String.valueOf((int)settings.getLoggerWindowLocation().getY()));
        loggerSettings.appendChild(location);
        IIOMetadataNode tabs = new IIOMetadataNode("tabs");
        tabs.setAttribute("selected", String.valueOf(settings.getLoggerSelectedTabIndex()));
        tabs.setAttribute("showlist", String.valueOf(settings.getLoggerParameterListState()));
        loggerSettings.appendChild(tabs);
        IIOMetadataNode definition = new IIOMetadataNode("definition");
        definition.setAttribute("path", settings.getLoggerDefinitionFilePath());
        loggerSettings.appendChild(definition);
        IIOMetadataNode profile = new IIOMetadataNode("profile");
        profile.setAttribute("path", settings.getLoggerProfileFilePath());
        loggerSettings.appendChild(profile);
        IIOMetadataNode filelogging = new IIOMetadataNode("filelogging");
        filelogging.setAttribute("path", settings.getLoggerOutputDirPath());
        filelogging.setAttribute("switchid", settings.getFileLoggingControllerSwitchId());
        filelogging.setAttribute("active", String.valueOf(settings.isFileLoggingControllerSwitchActive()));
        filelogging.setAttribute("absolutetimestamp", String.valueOf(settings.isFileLoggingAbsoluteTimestamp()));
        loggerSettings.appendChild(filelogging);
        IIOMetadataNode debug = new IIOMetadataNode("debug");
        debug.setAttribute("level", settings.getLoggerDebuggingLevel());
        loggerSettings.appendChild(debug);
        Map<String, String> pluginPorts = settings.getLoggerPluginPorts();
        if (pluginPorts != null && !pluginPorts.isEmpty()) {
            IIOMetadataNode plugins = new IIOMetadataNode("plugins");
            for (Map.Entry<String, String> entry : pluginPorts.entrySet()) {
                IIOMetadataNode plugin = new IIOMetadataNode("plugin");
                plugin.setAttribute("id", entry.getKey());
                plugin.setAttribute("port", entry.getValue());
                plugins.appendChild(plugin);
            }
        }
        return loggerSettings;
    }

    private IIOMetadataNode buildTableClipboardFormat(Settings settings) {
        IIOMetadataNode tableClipboardFormatSetting = new IIOMetadataNode("table-clipboard-format");
        tableClipboardFormatSetting.setAttribute("format-string", settings.getTableClipboardFormat());
        IIOMetadataNode tableFormatSetting = new IIOMetadataNode("table");
        IIOMetadataNode table1DFormatSetting = new IIOMetadataNode("table1D");
        IIOMetadataNode table2DFormatSetting = new IIOMetadataNode("table2D");
        IIOMetadataNode table3DFormatSetting = new IIOMetadataNode("table3D");
        tableFormatSetting.setAttribute("table-header", settings.getTableHeader());
        table1DFormatSetting.setAttribute("table-header", settings.getTable1DHeader());
        table2DFormatSetting.setAttribute("table-header", settings.getTable2DHeader());
        table3DFormatSetting.setAttribute("table-header", settings.getTable3DHeader());
        tableClipboardFormatSetting.appendChild(tableFormatSetting);
        tableClipboardFormatSetting.appendChild(table1DFormatSetting);
        tableClipboardFormatSetting.appendChild(table2DFormatSetting);
        tableClipboardFormatSetting.appendChild(table3DFormatSetting);
        return tableClipboardFormatSetting;
    }

    private IIOMetadataNode buildIcons(Settings settings) {
        IIOMetadataNode iconsSettings = new IIOMetadataNode("icons");
        IIOMetadataNode editorIconsScaleSettings = new IIOMetadataNode("editor-toolbar");
        editorIconsScaleSettings.setAttribute("scale", String.valueOf(settings.getEditorIconScale()));
        IIOMetadataNode tableIconsScaleSettings = new IIOMetadataNode("table-toolbar");
        tableIconsScaleSettings.setAttribute("scale", String.valueOf(settings.getTableIconScale()));
        iconsSettings.appendChild(editorIconsScaleSettings);
        iconsSettings.appendChild(tableIconsScaleSettings);
        return iconsSettings;
    }
}

