/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import com.romraider.Settings;
import com.romraider.xml.DOMHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.util.HashMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSettingsUnmarshaller {
    public Settings unmarshallSettings(Node rootNode) {
        Settings settings = new Settings();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("window")) {
                settings = this.unmarshallWindow(n, settings);
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("files")) {
                settings = this.unmarshallFiles(n, settings);
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("options")) {
                settings = this.unmarshallOptions(n, settings);
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("tabledisplay")) {
                settings = this.unmarshallTableDisplay(n, settings);
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("logger")) {
                settings = this.unmarshallLogger(n, settings);
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("table-clipboard-format")) {
                settings = this.unmarshallClipboardFormat(n, settings);
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("icons")) continue;
            settings = this.unmarshallIcons(n, settings);
        }
        return settings;
    }

    private Settings unmarshallWindow(Node windowNode, Settings settings) {
        NodeList nodes = windowNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("maximized")) {
                settings.setWindowMaximized(DOMHelper.unmarshallAttribute(n, "value", false));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("size")) {
                settings.setWindowSize(new Dimension(DOMHelper.unmarshallAttribute(n, "y", 600), DOMHelper.unmarshallAttribute(n, "x", 800)));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("location")) {
                settings.setWindowLocation(new Point(DOMHelper.unmarshallAttribute(n, "x", 0), DOMHelper.unmarshallAttribute(n, "y", 0)));
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("splitpane")) continue;
            settings.setSplitPaneLocation(DOMHelper.unmarshallAttribute(n, "location", 150));
        }
        return settings;
    }

    private Settings unmarshallFiles(Node urlNode, Settings settings) {
        NodeList nodes = urlNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("ecudefinitionfile")) {
                settings.addEcuDefinitionFile(new File(DOMHelper.unmarshallAttribute(n, "name", "ecu_defs.xml")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("image_dir")) {
                settings.setLastImageDir(new File(DOMHelper.unmarshallAttribute(n, "path", "ecu_defs.xml")));
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("repository-dir")) continue;
            settings.setLastRepositoryDir(new File(DOMHelper.unmarshallAttribute(n, "path", "repositories")));
        }
        return settings;
    }

    private Settings unmarshallOptions(Node optionNode, Settings settings) {
        NodeList nodes = optionNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("obsoletewarning")) {
                settings.setObsoleteWarning(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "true")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("debug")) {
                settings.setDebug(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "true")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("calcconflictwarning")) {
                settings.setCalcConflictWarning(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "true")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("userlevel")) {
                settings.setUserLevel(DOMHelper.unmarshallAttribute(n, "value", 1));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("tableclickcount")) {
                settings.setTableClickCount(DOMHelper.unmarshallAttribute(n, "value", 2));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("tableclickbehavior")) {
                settings.setTableClickBehavior(DOMHelper.unmarshallAttribute(n, "value", 0));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("version")) {
                settings.setRecentVersion(DOMHelper.unmarshallAttribute(n, "value", ""));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("savedebugtables")) {
                settings.setSaveDebugTables(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "false")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("displayhightables")) {
                settings.setDisplayHighTables(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "false")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("valuelimitwarning")) {
                settings.setValueLimitWarning(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "true")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("coloraxis")) {
                settings.setColorAxis(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "false")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("showtabletoolbarborder")) {
                settings.setShowTableToolbarBorder(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "false")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("openromexpanded")) {
                settings.setOpenExpanded(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "true")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("alwaysopentableatzero")) {
                settings.setAlwaysOpenTableAtZero(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "false")));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("defaultscale")) {
                settings.setDefaultScale(DOMHelper.unmarshallAttribute(n, "value", "Metric"));
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("scaleHeadersAndData")) continue;
            settings.setScaleHeadersAndData(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(n, "value", "true")));
        }
        return settings;
    }

    private Settings unmarshallTableDisplay(Node tableDisplayNode, Settings settings) {
        NodeList nodes = tableDisplayNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("font")) {
                settings.setTableFont(new Font(DOMHelper.unmarshallAttribute(n, "face", "Arial"), DOMHelper.unmarshallAttribute(n, "decoration", 1), DOMHelper.unmarshallAttribute(n, "size", 12)));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("cellsize")) {
                settings.setCellSize(new Dimension(DOMHelper.unmarshallAttribute(n, "width", 42), DOMHelper.unmarshallAttribute(n, "height", 18)));
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("colors")) continue;
            settings = this.unmarshallColors(n, settings);
        }
        return settings;
    }

    private Settings unmarshallColors(Node colorNode, Settings settings) {
        NodeList nodes = colorNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("max")) {
                settings.setMaxColor(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("min")) {
                settings.setMinColor(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("highlight")) {
                settings.setHighlightColor(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("select")) {
                settings.setSelectColor(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("increaseborder")) {
                settings.setIncreaseBorder(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("decreaseborder")) {
                settings.setDecreaseBorder(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("axis")) {
                settings.setAxisColor(this.unmarshallColor(n));
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("warning")) continue;
            settings.setWarningColor(this.unmarshallColor(n));
        }
        return settings;
    }

    private Settings unmarshallLogger(Node loggerNode, Settings settings) {
        NodeList nodes = loggerNode.getChildNodes();
        if (loggerNode.getNodeType() == 1 && loggerNode.getNodeName().equalsIgnoreCase("logger")) {
            settings.setLocale(DOMHelper.unmarshallAttribute(loggerNode, "locale", "system"));
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("serial")) {
                settings.setLoggerPortDefault(DOMHelper.unmarshallAttribute(n, "port", ""));
                settings.setRefreshMode(DOMHelper.unmarshallAttribute(n, "refresh", false));
                settings.setDestinationId((byte)DOMHelper.unmarshallAttribute(n, "ecuid", 16));
                settings.setFastPoll(DOMHelper.unmarshallAttribute(n, "fastpoll", true));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("protocol")) {
                settings.setLoggerProtocol(DOMHelper.unmarshallAttribute(n, "name", "SSM"));
                settings.setTransportProtocol(DOMHelper.unmarshallAttribute(n, "transport", "ISO9141"));
                settings.setJ2534Device(DOMHelper.unmarshallAttribute(n, "library", null));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("maximized")) {
                settings.setLoggerWindowMaximized(DOMHelper.unmarshallAttribute(n, "value", false));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("size")) {
                settings.setLoggerWindowSize(new Dimension(DOMHelper.unmarshallAttribute(n, "y", 600), DOMHelper.unmarshallAttribute(n, "x", 1000)));
                settings.setLoggerDividerLocation(DOMHelper.unmarshallAttribute(n, "divider", 500));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("location")) {
                settings.setLoggerWindowLocation(new Point(DOMHelper.unmarshallAttribute(n, "x", 150), DOMHelper.unmarshallAttribute(n, "y", 150)));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("tabs")) {
                settings.setLoggerSelectedTabIndex(DOMHelper.unmarshallAttribute(n, "selected", 0));
                settings.setLoggerParameterListState(DOMHelper.unmarshallAttribute(n, "showlist", true));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("definition")) {
                settings.setLoggerDefinitionFilePath(DOMHelper.unmarshallAttribute(n, "path", settings.getLoggerDefinitionFilePath()));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("profile")) {
                settings.setLoggerProfileFilePath(DOMHelper.unmarshallAttribute(n, "path", ""));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("filelogging")) {
                settings.setLoggerOutputDirPath(DOMHelper.unmarshallAttribute(n, "path", ""));
                settings.setFileLoggingControllerSwitchId(DOMHelper.unmarshallAttribute(n, "switchid", settings.getFileLoggingControllerSwitchId()));
                settings.setFileLoggingControllerSwitchActive(DOMHelper.unmarshallAttribute(n, "active", true));
                settings.setFileLoggingAbsoluteTimestamp(DOMHelper.unmarshallAttribute(n, "absolutetimestamp", false));
                continue;
            }
            if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase("debug")) {
                settings.setLoggerDebuggingLevel(DOMHelper.unmarshallAttribute(n, "level", "info"));
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("plugins")) continue;
            HashMap<String, String> pluginPorts = new HashMap<String, String>();
            NodeList pluginNodes = n.getChildNodes();
            for (int j = 0; j < pluginNodes.getLength(); ++j) {
                Node pluginNode = pluginNodes.item(j);
                if (pluginNode.getNodeType() == 1 && pluginNode.getNodeName().equalsIgnoreCase("plugin")) {
                    String port;
                    String id = DOMHelper.unmarshallAttribute(pluginNode, "id", null);
                    if (id == null || id.trim().length() == 0 || (port = DOMHelper.unmarshallAttribute(pluginNode, "port", null)) == null || port.trim().length() == 0) continue;
                    pluginPorts.put(id.trim(), port.trim());
                    continue;
                }
                if (pluginNode.getNodeType() == 1 && !pluginNode.getNodeName().equalsIgnoreCase("phidgets")) continue;
            }
            settings.setLoggerPluginPorts(pluginPorts);
        }
        return settings;
    }

    private Color unmarshallColor(Node colorNode) {
        return new Color(DOMHelper.unmarshallAttribute(colorNode, "r", 155), DOMHelper.unmarshallAttribute(colorNode, "g", 155), DOMHelper.unmarshallAttribute(colorNode, "b", 155));
    }

    private Settings unmarshallClipboardFormat(Node formatNode, Settings settings) {
        String tableClipboardFormat = DOMHelper.unmarshallAttribute(formatNode, "format-string", "Default");
        if (!tableClipboardFormat.equalsIgnoreCase("Custom")) {
            if (tableClipboardFormat.equalsIgnoreCase("Airboys")) {
                settings.setAirboysFormat();
                return settings;
            }
            settings.setDefaultFormat();
            return settings;
        }
        settings.setTableClipboardFormat("Custom");
        NodeList tableFormats = formatNode.getChildNodes();
        for (int i = 0; i < tableFormats.getLength(); ++i) {
            Node tableNode = tableFormats.item(i);
            if (tableNode.getNodeType() != 1) continue;
            if (tableNode.getNodeName().equalsIgnoreCase("table")) {
                settings.setTableHeader(DOMHelper.unmarshallAttribute(tableNode, "table-header", Settings.DEFAULT_TABLE_HEADER));
                continue;
            }
            if (tableNode.getNodeName().equalsIgnoreCase("table1D")) {
                settings.setTable1DHeader(DOMHelper.unmarshallAttribute(tableNode, "table-header", ""));
                continue;
            }
            if (tableNode.getNodeName().equalsIgnoreCase("table2D")) {
                settings.setTable2DHeader(DOMHelper.unmarshallAttribute(tableNode, "table-header", Settings.DEFAULT_TABLE2D_HEADER));
                continue;
            }
            if (!tableNode.getNodeName().equalsIgnoreCase("table3D")) continue;
            settings.setTable3DHeader(DOMHelper.unmarshallAttribute(tableNode, "table-header", Settings.DEFAULT_TABLE3D_HEADER));
        }
        return settings;
    }

    private Settings unmarshallIcons(Node iconsNode, Settings settings) {
        NodeList iconScales = iconsNode.getChildNodes();
        for (int i = 0; i < iconScales.getLength(); ++i) {
            Node scaleNode = iconScales.item(i);
            if (scaleNode.getNodeType() != 1) continue;
            if (scaleNode.getNodeName().equalsIgnoreCase("editor-toolbar")) {
                try {
                    settings.setEditorIconScale(DOMHelper.unmarshallAttribute(scaleNode, "scale", 50));
                }
                catch (NumberFormatException ex) {
                    settings.setEditorIconScale(50);
                }
                continue;
            }
            if (!scaleNode.getNodeName().equalsIgnoreCase("table-toolbar")) continue;
            try {
                settings.setTableIconScale(DOMHelper.unmarshallAttribute(scaleNode, "scale", 70));
                continue;
            }
            catch (NumberFormatException ex) {
                settings.setTableIconScale(70);
            }
        }
        return settings;
    }
}

