/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class RomAttributeParser {
    private RomAttributeParser() {
    }

    public static int parseEndian(String input) {
        if (input.equalsIgnoreCase("big") || input.equalsIgnoreCase(String.valueOf(2))) {
            return 2;
        }
        if (input.equalsIgnoreCase("little") || input.equalsIgnoreCase(String.valueOf(1))) {
            return 1;
        }
        return 1;
    }

    public static int parseHexString(String input) {
        if (input.equals("0")) {
            return 0;
        }
        if (input.length() > 2 && input.substring(0, 2).equalsIgnoreCase("0x")) {
            return Integer.parseInt(input.substring(2), 16);
        }
        return Integer.parseInt(input, 16);
    }

    public static int parseStorageType(String input) {
        if (input.equalsIgnoreCase("float")) {
            return 99;
        }
        if (input.startsWith("uint")) {
            return Integer.parseInt(input.substring(4)) / 8;
        }
        if (input.startsWith("int")) {
            return Integer.parseInt(input.substring(3)) / 8;
        }
        return Integer.parseInt(input);
    }

    public static boolean parseStorageDataSign(String input) {
        return input.startsWith("int");
    }

    public static int parseScaleType(String input) {
        if (input.equalsIgnoreCase("inverse")) {
            return 2;
        }
        return 1;
    }

    public static int parseTableType(String input) {
        if (input.equalsIgnoreCase("3D") || input.equalsIgnoreCase(String.valueOf(3))) {
            return 3;
        }
        if (input.equalsIgnoreCase("2D") || input.equalsIgnoreCase(String.valueOf(2))) {
            return 2;
        }
        if (input.equalsIgnoreCase("X Axis") || input.equalsIgnoreCase("Static X Axis") || input.equalsIgnoreCase(String.valueOf(4))) {
            return 4;
        }
        if (input.equalsIgnoreCase("Y Axis") || input.equalsIgnoreCase("Static Y Axis") || input.equalsIgnoreCase(String.valueOf(5))) {
            return 5;
        }
        return 1;
    }

    public static long parseByteValue(byte[] input, int endian, int address, int length, boolean signed) throws ArrayIndexOutOfBoundsException, IndexOutOfBoundsException {
        long output = 0L;
        ByteBuffer bb = ByteBuffer.wrap(input, address, length);
        if (endian == 1) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        switch (length) {
            case 1: {
                output = bb.get();
                break;
            }
            case 2: {
                output = bb.getShort();
                break;
            }
            case 4: {
                output = bb.getInt();
            }
        }
        if (!signed) {
            switch (length) {
                case 1: {
                    output &= 0xFFL;
                    break;
                }
                case 2: {
                    output &= 0xFFFFL;
                    break;
                }
                case 4: {
                    output &= 0xFFFFFFFFL;
                }
            }
        }
        return output;
    }

    public static byte[] parseIntegerValue(int input, int endian, int length) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(length);
            if (endian == 1) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            switch (length) {
                case 1: {
                    bb.put((byte)input);
                    break;
                }
                case 2: {
                    bb.putShort((short)input);
                    break;
                }
                case 4: {
                    bb.putInt(input);
                }
            }
            return bb.array();
        }
        catch (BufferOverflowException ex) {
            throw new BufferOverflowException();
        }
    }

    public static int parseFileSize(String input) throws NumberFormatException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException ex) {
            if (input.substring(input.length() - 2).equalsIgnoreCase("kb")) {
                return Integer.parseInt(input.substring(0, input.length() - 2)) * 1024;
            }
            if (input.substring(input.length() - 2).equalsIgnoreCase("mb")) {
                return Integer.parseInt(input.substring(0, input.length() - 2)) * 1024 * 1024;
            }
            throw new NumberFormatException();
        }
    }

    public static byte[] floatToByte(float input, int endian) {
        byte[] output = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(output, 0, 4);
        if (endian == 1) {
            bb.order(ByteOrder.BIG_ENDIAN);
        } else {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        bb.putFloat(input);
        return bb.array();
    }

    public static float byteToFloat(byte[] input, int endian) {
        ByteBuffer bb = ByteBuffer.wrap(input, 0, 4);
        if (endian == 1) {
            bb.order(ByteOrder.BIG_ENDIAN);
        } else {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        return bb.getFloat();
    }
}

