/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.ExecHelper;
import com.rusefi.FileLog;
import com.rusefi.IoUtil;
import com.rusefi.TestingUtils;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.waves.EngineChart;
import com.rusefi.waves.EngineReport;

public class AutoTest {
    public static final int COMPLEX_COMMAND_RETRY = 10000;
    static int currentEngineType;

    static void mainTestBody() {
        IoUtil.sendCommand("fl 1");
        AutoTest.test2003DodgeNeon();
        AutoTest.testFordAspire();
        AutoTest.test1995DodgeNeon();
        AutoTest.testMazdaProtege();
        AutoTest.testBmwE34();
        AutoTest.testSachs();
        AutoTest.testMitsu();
        AutoTest.testCitroenBerlingo();
        AutoTest.testMazda626();
        AutoTest.testFord6();
        AutoTest.testFordFiesta();
    }

    private static void testSachs() {
        AutoTest.setEngineType(29);
        String msg = "BMW";
        IoUtil.changeRpm(1200);
    }

    private static void testBmwE34() {
        AutoTest.setEngineType(25);
        IoUtil.sendCommand("chart 1");
        String msg = "BMW";
        IoUtil.changeRpm(200);
        EngineChart chart = TestingUtils.nextChart();
        double x = 173.988;
        TestingUtils.assertWave(msg, chart, "c1", 0.0199666, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.changeRpm(1200);
        chart = TestingUtils.nextChart();
        x = 688.464;
        TestingUtils.assertWave(msg, chart, "c1", 0.0597999999, x, x + 180.0, x + 360.0, x + 540.0);
        x = 101.0;
        TestingUtils.assertWave(msg, chart, "map", 0.139, x, x + 120.0, x + 240.0, x + 360.0, x + 480.0, x + 600.0);
    }

    private static void testMitsu() {
        AutoTest.setEngineType(16);
        IoUtil.sendCommand("disable cylinder_cleanup");
        String msg = "Mitsubishi";
        IoUtil.changeRpm(200);
        IoUtil.changeRpm(1200);
    }

    private static void testCitroenBerlingo() {
        AutoTest.setEngineType(15);
        String msg = "Citroen";
        IoUtil.changeRpm(1200);
    }

    static void setEngineType(int type) {
        currentEngineType = type;
        IoUtil.sendCommand("set engine_type " + type, 10000, 30);
        IoUtil.sleep(10);
        IoUtil.sendCommand("enable self_stimulation");
    }

    private static void testMazda626() {
        AutoTest.setEngineType(28);
        String msg = "mazda 626 default cranking";
        IoUtil.changeRpm(200);
        EngineChart chart = TestingUtils.nextChart();
        double x = 102.0;
        TestingUtils.assertWave(msg, chart, "c1", 0.1944, x, x + 180.0, x + 360.0, x + 540.0);
    }

    private static void test2003DodgeNeon() {
        AutoTest.setEngineType(23);
        IoUtil.sendCommand("set suckedOffCoef 0");
        IoUtil.sendCommand("set addedToWallCoef 0");
        IoUtil.sendCommand("set mock_map_voltage 1");
        IoUtil.sendCommand("set mock_vbatt_voltage 1.20");
        IoUtil.sendCommand("disable cylinder_cleanup");
        String msg = "2003 Neon cranking ";
        IoUtil.changeRpm(200);
        IoUtil.changeRpm(250);
        IoUtil.changeRpm(200);
        AutoTest.assertEquals("VBatt", 12.0, SensorCentral.getInstance().getValue(Sensor.VBATT));
        EngineChart chart = TestingUtils.nextChart();
        double x = 100.0;
        TestingUtils.assertWave(true, msg, chart, "c1", 0.194433, 0.01, 0.05, x + 180.0, x + 540.0);
        AutoTest.assertWaveNull(msg, chart, "c2");
        TestingUtils.assertWave(true, msg, chart, "c3", 0.194433, 0.01, 0.05, x, x + 360.0);
        AutoTest.assertWaveNull(msg, chart, "c4");
        x = 176.856;
        double widthRatio = 0.25;
        TestingUtils.assertWave(true, msg, chart, "i1", 0.01056666666666691, 0.02, widthRatio, x, x + 180.0, x + 360.0, x + 540.0);
        TestingUtils.assertWave(true, msg, chart, "i2", 0.01056666666666691, 0.02, widthRatio, x, x + 180.0, x + 360.0, x + 540.0);
        TestingUtils.assertWave(true, msg, chart, "i3", 0.01056666666666691, 0.02, widthRatio, x, x + 180.0, x + 360.0, x + 540.0);
        TestingUtils.assertWave(true, msg, chart, "i4", 0.01056666666666691, 0.02, widthRatio, x, x + 180.0, x + 360.0, x + 540.0);
        msg = "2003 Neon running";
        IoUtil.changeRpm(2000);
        IoUtil.changeRpm(2700);
        IoUtil.changeRpm(2000);
        chart = TestingUtils.nextChart();
        x = 104.0;
        TestingUtils.assertWave(true, msg, chart, "c1", 0.13299999999999998, 0.05, 0.05, x + 180.0, x + 540.0);
        AutoTest.assertWaveNull(msg, chart, "c2");
        TestingUtils.assertWave(true, msg, chart, "c3", 0.13299999999999998, 0.05, 0.05, x, x + 360.0);
        AutoTest.assertWaveNull(msg, chart, "c4");
        chart = TestingUtils.nextChart();
        x = 74.0;
        TestingUtils.assertWave(true, msg, chart, "i1", 0.29233, 0.05, 0.2, x + 360.0);
        TestingUtils.assertWave(true, msg, chart, "i2", 0.29233, 0.15, 0.2, x + 180.0);
        TestingUtils.assertWave(true, msg, chart, "i3", 0.29233, 0.15, 0.05, x + 540.0);
        TestingUtils.assertWave(true, msg, chart, "i4", 0.29233, 0.15, 0.2, x);
        IoUtil.sendCommand("enable trigger_only_front");
        chart = TestingUtils.nextChart();
        TestingUtils.assertWave(true, msg, chart, "i1", 0.29233, 0.1, 0.2, x + 360.0);
        TestingUtils.assertWave(true, msg, chart, "i2", 0.29233, 0.05, 0.2, x + 180.0);
        TestingUtils.assertWave(true, msg, chart, "i3", 0.29233, 0.1, 0.2, x + 540.0);
        TestingUtils.assertWave(true, msg, chart, "i4", 0.29233, 0.1, 0.2, x);
        IoUtil.sendCommand("set_whole_timing_map 520");
        chart = TestingUtils.nextChart();
        x = 328.0;
        TestingUtils.assertWave(true, msg, chart, "c1", 0.13299999999999998, 0.05, 0.05, x + 180.0, x + 540.0);
        IoUtil.sendCommand("set_whole_timing_map 0");
        chart = TestingUtils.nextChart();
        x = 128.0;
        TestingUtils.assertWave(true, msg, chart, "c1", 0.13299999999999998, 0.05, 0.05, x + 180.0, x + 540.0);
    }

    private static void testMazdaProtege() {
        AutoTest.setEngineType(14);
        IoUtil.sendCommand("set mock_vbatt_voltage 1.395");
        IoUtil.changeRpm(200);
        IoUtil.changeRpm(260);
        IoUtil.changeRpm(200);
        String msg = "ProtegeLX cranking";
        EngineChart chart = TestingUtils.nextChart();
        AutoTest.assertEquals("", 12.0, SensorCentral.getInstance().getValue(Sensor.VBATT), 0.1);
        double x = 107.0;
        TestingUtils.assertWave(msg, chart, "c3", 0.194433, x);
        TestingUtils.assertWave(msg, chart, "c1", 0.194433, x + 540.0);
        x = 0.0;
        TestingUtils.assertWaveFall(msg, chart, "i1", 0.008566666666, x, x + 180.0, x + 360.0, x + 540.0);
        TestingUtils.assertWaveFall(msg, chart, "i2", 0.008566666666, x, x + 180.0, x + 360.0, x + 540.0);
        msg = "ProtegeLX running";
        IoUtil.changeRpm(2000);
        chart = TestingUtils.nextChart();
        x = 112.0;
        TestingUtils.assertWave(msg, chart, "c1", 0.13333333333333333, x, x + 180.0, x + 360.0, x + 540.0);
        x = 0.0;
        TestingUtils.assertWaveFall(msg, chart, "i1", 0.21433333333333346, x + 180.0, x + 540.0);
        TestingUtils.assertWaveFall(msg, chart, "i2", 0.21433333333333346, x, x + 360.0);
    }

    private static void test1995DodgeNeon() {
        AutoTest.setEngineType(2);
        AutoTest.sendComplexCommand("set_whole_fuel_map 3");
        AutoTest.sendComplexCommand("set_individual_coils_ignition");
        IoUtil.changeRpm(2000);
        EngineChart chart = TestingUtils.nextChart();
        String msg = "1995 Neon";
        double x = -70.0;
        TestingUtils.assertWaveFall(msg, chart, "i4", 0.133, x + 540.0);
        TestingUtils.assertWaveFall(msg, chart, "i2", 0.133, x + 720.0);
        TestingUtils.assertWaveFall(msg, chart, "i1", 0.133, x + 180.0);
        TestingUtils.assertWaveFall(msg, chart, "i3", 0.133, x + 360.0);
        x = 112.92;
        TestingUtils.assertWave(msg, chart, "c4", 0.13333, x + 540.0);
        TestingUtils.assertWave(msg, chart, "c2", 0.13333, x);
        TestingUtils.assertWave(msg, chart, "c1", 0.13333, x + 180.0);
        TestingUtils.assertWave(msg, chart, "c3", 0.13333, x + 360.0);
        IoUtil.sendCommand("set mock_map_voltage 1");
        AutoTest.sendComplexCommand("set algorithm 3");
        IoUtil.changeRpm(2600);
        IoUtil.changeRpm(2000);
        chart = TestingUtils.nextChart();
        x = -70.0;
        TestingUtils.assertWaveFall(msg, chart, "i4", 0.493, x + 540.0);
    }

    private static void testFordFiesta() {
        AutoTest.setEngineType(4);
        IoUtil.changeRpm(2000);
        EngineChart chart = TestingUtils.nextChart();
        String msg = "Fiesta";
        double x = 312.0;
        TestingUtils.assertWave("wasted spark #1 with Fiesta", chart, "c1", 0.1333333, x, x + 360.0);
        AutoTest.assertWaveNull(chart, "c2");
        TestingUtils.assertWave("wasted spark #3 with Fiesta", chart, "c3", 0.1333333, x + 180.0, x + 540.0);
        AutoTest.assertWaveNull(msg, chart, "c4");
    }

    private static void testFord6() {
        AutoTest.setEngineType(7);
        IoUtil.changeRpm(2000);
        EngineChart chart = TestingUtils.nextChart();
        String msg = "ford 6";
        double x = 7.0;
        TestingUtils.assertWave(msg, chart, "c1", 0.01666, x, x + 120.0, x + 240.0, x + 360.0, x + 480.0, x + 600.0);
        AutoTest.assertWaveNull(msg, chart, "t2");
        AutoTest.sendComplexCommand("set trigger_type 1");
        chart = TestingUtils.nextChart();
        TestingUtils.assertTrue(msg, chart.get("t2") != null);
    }

    private static void testFordAspire() {
        AutoTest.setEngineType(3);
        IoUtil.sendCommand("disable cylinder_cleanup");
        IoUtil.sendCommand("set mock_map_voltage 1");
        IoUtil.sendCommand("set mock_vbatt_voltage 2.2");
        AutoTest.sendComplexCommand("set cranking_rpm 500");
        IoUtil.changeRpm(200);
        EngineChart chart = TestingUtils.nextChart();
        AutoTest.assertEquals(12.0, SensorCentral.getInstance().getValue(Sensor.VBATT));
        double x = 55.0;
        TestingUtils.assertWave("aspire default cranking ", chart, "c1", 0.1944, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.changeRpm(600);
        chart = TestingUtils.nextChart();
        x = 78.0;
        TestingUtils.assertWave(true, "aspire default running ", chart, "c1", 0.04, 0.1, 0.1, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.changeRpm(200);
        IoUtil.sendCommand("set cranking_charge_angle 65");
        IoUtil.sendCommand("set cranking_timing_angle -31");
        chart = TestingUtils.nextChart();
        x = 55.0;
        TestingUtils.assertWave("aspire cranking", chart, "c1", 0.18, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.sendCommand("set cranking_timing_angle -40");
        chart = TestingUtils.nextChart();
        x = 64.0;
        TestingUtils.assertWave("aspire", chart, "c1", 0.18, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.sendCommand("set cranking_timing_angle 149");
        IoUtil.sendCommand("set cranking_charge_angle 40");
        chart = TestingUtils.nextChart();
        x = 80.0;
        TestingUtils.assertWave("aspire", chart, "c1", 0.1111111111111111, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.sendCommand("set cranking_charge_angle 65");
        IoUtil.changeRpm(600);
        AutoTest.sendComplexCommand("set cranking_rpm 700");
        chart = TestingUtils.nextChart();
        x = 55.0;
        TestingUtils.assertWave("cranking@600", chart, "c1", 0.18, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.changeRpm(2000);
        IoUtil.sendCommand("set_whole_fuel_map 1.57");
        IoUtil.changeRpm(2600);
        IoUtil.changeRpm(2000);
        chart = TestingUtils.nextChart();
        String msg = "aspire running";
        TestingUtils.assertWaveFall(msg, chart, "i1", 0.109, 238.75);
        TestingUtils.assertWaveFall(msg, chart, "i2", 0.109, 53.04);
        TestingUtils.assertWaveFall(msg, chart, "i3", 0.109, 417.04);
        TestingUtils.assertWaveFall(msg, chart, "i4", 0.109, 594.04);
        x = 7.0;
        TestingUtils.assertWave(chart, "c1", 0.133, x, x + 180.0, x + 360.0, x + 540.0);
        IoUtil.sendCommand("set_fuel_map 2200 4 15.66");
        IoUtil.sendCommand("set_fuel_map 2000 4 15.66");
        IoUtil.sendCommand("set_fuel_map 2200 4.2 15.66");
        IoUtil.sendCommand("set_fuel_map 2000 4.2 15.66");
        IoUtil.sendCommand("set mock_maf_voltage 2");
        AutoTest.sendComplexCommand("set global_trigger_offset_angle 175");
        chart = TestingUtils.nextChart();
        TestingUtils.assertWaveFall(msg + " fuel", chart, "i1", 0.763, 238.75);
        TestingUtils.assertWaveFall(msg + " fuel", chart, "i2", 0.763, 53.04);
        TestingUtils.assertWaveFall(msg + " fuel", chart, "i3", 0.763, 417.04);
        TestingUtils.assertWaveFall(msg + " fuel", chart, "i4", 0.763, 594.04);
        x = 33.0;
        TestingUtils.assertWave(chart, "c1", 0.133, x, x + 180.0, x + 360.0, x + 540.0);
        AutoTest.assertWaveNull(chart, "c2");
        AutoTest.sendComplexCommand("set global_trigger_offset_angle 130");
        AutoTest.sendComplexCommand("set injection_offset 369");
        chart = TestingUtils.nextChart();
        x = 33.0;
        TestingUtils.assertWave(chart, "c1", 0.133, x, x + 180.0, x + 360.0, x + 540.0);
        AutoTest.sendComplexCommand("set_individual_coils_ignition");
        chart = TestingUtils.nextChart();
        TestingUtils.assertWave("Switching Aspire into INDIVIDUAL_COILS mode", chart, "c2", 0.133, x + 540.0);
        TestingUtils.assertWave(chart, "c3", 0.133, x + 180.0);
        IoUtil.sendCommand("set_whole_timing_map 520");
        chart = TestingUtils.nextChart();
        x = 58.92;
        TestingUtils.assertWave(chart, "c2", 0.133, x);
        IoUtil.sendCommand("set mock_maf_voltage 2");
        AutoTest.sendComplexCommand("set algorithm 3");
        IoUtil.changeRpm(2400);
        IoUtil.changeRpm(2000);
        TestingUtils.nextChart();
        chart = TestingUtils.nextChart();
        AutoTest.assertEquals(69.12, SensorCentral.getInstance().getValue(Sensor.MAP));
        x = 8.88;
        TestingUtils.assertWave(false, msg + " fuel SD #1", chart, "i1", 0.577, 0.1, 0.1, x + 180.0);
        TestingUtils.assertWave(false, msg + " fuel SD #2", chart, "i2", 0.577, 0.1, 0.1, x);
        TestingUtils.assertWave(false, msg + " fuel SD #3", chart, "i3", 0.577, 0.1, 0.1, x + 360.0);
        TestingUtils.assertWave(false, msg + " fuel SD #4", chart, "i4", 0.577, 0.1, 0.1, x + 540.0);
        IoUtil.changeRpm(10000);
        chart = TestingUtils.nextChart();
        AutoTest.assertWaveNull("hard limit check", chart, "i1");
    }

    private static void assertEquals(double expected, double actual) {
        AutoTest.assertEquals("", expected, actual);
    }

    private static void assertEquals(String msg, double expected, double actual) {
        AutoTest.assertEquals(msg, expected, actual, 0.05);
    }

    private static void assertEquals(String msg, double expected, double actual, double ratio) {
        if (!EngineReport.isCloseEnough(expected, actual, ratio)) {
            throw new IllegalStateException(msg + " Expected " + expected + " but got " + actual);
        }
    }

    private static void sendComplexCommand(String command) {
        IoUtil.sendCommand(command, 10000, 20);
    }

    private static void assertWaveNull(EngineChart chart, String key) {
        AutoTest.assertWaveNull("", chart, key);
    }

    private static void assertWaveNull(String msg, EngineChart chart, String key) {
        TestingUtils.assertNull(msg + "chart for " + key, chart.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                System.exit(-1);
            }
        });
        long start = System.currentTimeMillis();
        FileLog.SIMULATOR_CONSOLE.start();
        FileLog.MAIN.start();
        boolean failed = false;
        try {
            IoUtil.launchSimulator(true);
            AutoTest.mainTestBody();
        }
        catch (Throwable e) {
            e.printStackTrace();
            failed = true;
        }
        finally {
            ExecHelper.destroy();
        }
        if (failed) {
            System.exit(-1);
        }
        FileLog.MAIN.logLine("*******************************************************************************");
        FileLog.MAIN.logLine("************************************  Looks good! *****************************");
        FileLog.MAIN.logLine("*******************************************************************************");
        long time = (System.currentTimeMillis() - start) / 1000L;
        FileLog.MAIN.logLine("Done in " + time + "secs");
        System.exit(0);
    }
}

