/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AverageAngles;
import com.rusefi.SensorSnifferCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.util.LocalizedMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AverageAnglePanel {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final AverageAngles aa = new AverageAngles();
    private final JTextArea text = new JTextArea();

    public AverageAnglePanel() {
        JButton reset = new JButton(LocalizedMessages.RESET.getMessage());
        reset.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AverageAnglePanel.this.aa.clear();
                AverageAnglePanel.this.showResults();
            }
        });
        this.panel.add((Component)reset, "North");
        this.panel.add((Component)new JScrollPane(this.text, 22, 30){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        }, "Center");
        SensorSnifferCentral.addListener(new SensorSnifferCentral.AnalogChartListener(){

            @Override
            public void onAnalogChart(String message) {
                int rpm = (int)SensorCentral.getInstance().getValue(Sensor.RPM);
                AverageAnglePanel.this.aa.add(rpm, message);
                AverageAnglePanel.this.showResults();
            }
        });
    }

    private void showResults() {
        String test = this.aa.getReport();
        this.text.setText(test);
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

