/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AverageAngles;
import com.rusefi.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class AverageAnglesUtil {
    public static final String KEY = "analog_chart";
    public static final String ANALOG_CHART = "analog_chart,";
    private static int currentRpm = -1;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("One parameter expected: log_file_name.csv");
            System.exit(-1);
        }
        String fileName = args[0];
        AverageAnglesUtil.runUtil(fileName, Logger.CONSOLE);
    }

    public static String runUtil(String fileName, Logger logger) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        AverageAngles aa = new AverageAngles();
        while ((line = br.readLine()) != null) {
            int index = line.indexOf("<EOT>: ");
            if (index == -1) continue;
            if ((line = line.substring(index + "<EOT>: ".length())).startsWith("time")) {
                String[] f = line.split(",");
                if (f.length <= 3 || !f[2].equals("rpm")) continue;
                currentRpm = Integer.parseInt(f[3]);
                logger.info("New rpm " + currentRpm);
                continue;
            }
            if (!line.startsWith(ANALOG_CHART)) continue;
            line = line.substring(ANALOG_CHART.length());
            String[] p = line.split(",");
            line = p[0];
            aa.add(currentRpm, line);
            logger.info(line);
        }
        String report = aa.getReport();
        System.out.println(report);
        return report;
    }
}

