/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.io.CommandQueue;
import com.rusefi.ui.MessagesView;
import com.rusefi.ui.util.UiUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class BenchTestPane {
    private final JPanel content = new JPanel(new GridLayout(2, 4));

    public BenchTestPane() {
        this.content.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.content.add(this.createFanTest());
        this.content.add(this.createFuelPumpTest());
        this.content.add(this.createSparkTest());
        this.content.add(this.createInjectorTest());
        this.content.add(this.createMILTest());
        this.content.add(this.createIdleTest());
        this.content.add(new MessagesView().messagesScroll);
    }

    private Component createMILTest() {
        BenchTestPanel panel = new BenchTestPanel("MIL", "check_engine.jpg", new JComponent[0]){

            @Override
            @NotNull
            protected String getCommand() {
                return "milbench";
            }
        };
        return panel.getContent();
    }

    private Component createIdleTest() {
        BenchTestPanel panel = new BenchTestPanel("Idle Valve", "idle_valve.png", new JComponent[0]){

            @Override
            @NotNull
            protected String getCommand() {
                return "idlebench";
            }
        };
        return panel.getContent();
    }

    private Component createFanTest() {
        BenchTestPanel panel = new BenchTestPanel("Radiator Fan", "radiator_fan.jpg", new JComponent[0]){

            @Override
            @NotNull
            protected String getCommand() {
                return "fanbench";
            }
        };
        return panel.getContent();
    }

    private Component createFuelPumpTest() {
        BenchTestPanel panel = new BenchTestPanel("Fuel Pump", "fuel_pump.jpg", new JComponent[0]){

            @Override
            @NotNull
            protected String getCommand() {
                return "fuelpumpbench";
            }
        };
        return panel.getContent();
    }

    private Component createSparkTest() {
        final JComboBox<Integer> indexes = this.createIndexCombo();
        BenchTestPanel panel = new BenchTestPanel("Spark #", "spark.jpg", new JComponent[]{indexes}){

            @Override
            protected String getCommand() {
                return "sparkbench2 1000 " + indexes.getSelectedItem() + " 5 333 3";
            }
        };
        return panel.getContent();
    }

    private Component createInjectorTest() {
        final JComboBox<Integer> indexes = this.createIndexCombo();
        BenchTestPanel panel = new BenchTestPanel("Injector #", "injector.png", new JComponent[]{indexes}){

            @Override
            protected String getCommand() {
                return "fuelbench2 1000 " + indexes.getSelectedItem() + " 5 333 3";
            }
        };
        return panel.getContent();
    }

    @NotNull
    private JComboBox<Integer> createIndexCombo() {
        JComboBox<Integer> indexes = new JComboBox<Integer>();
        for (int i = 1; i <= 12; ++i) {
            indexes.addItem(i);
        }
        return indexes;
    }

    public JPanel getContent() {
        return this.content;
    }

    private static abstract class BenchTestPanel {
        final JPanel panel = new JPanel(new FlowLayout(2, 5, 0));
        final JButton test = new JButton("Test");

        public BenchTestPanel(String text, String iconFileName, JComponent ... components) {
            ImageIcon icon = UiUtils.loadIcon(iconFileName);
            JPanel rightVerticalPanel = new JPanel(new VerticalFlowLayout());
            rightVerticalPanel.add(new JLabel(text));
            for (JComponent component : components) {
                rightVerticalPanel.add(component);
            }
            rightVerticalPanel.add(this.test);
            this.panel.add(new JLabel(icon));
            this.panel.add(rightVerticalPanel);
            int GAP = 3;
            this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(GAP, GAP, GAP, GAP)));
            this.test.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommandQueue.getInstance().write(this.getCommand());
                }
            });
        }

        protected abstract String getCommand();

        public Component getContent() {
            return UiUtils.wrap(this.panel);
        }
    }
}

