/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ConfigurationImage {
    public static final String BIN_HEADER = "RUSEFI0.1";
    private byte[] content;

    public ConfigurationImage(int size) {
        this.content = new byte[size];
    }

    public ConfigurationImage(byte[] content) {
        this.content = content;
    }

    public int getSize() {
        return this.content.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileContent() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] bytes = BIN_HEADER.getBytes();
            if (bytes.length != BIN_HEADER.length()) {
                throw new IllegalStateException("Encoding issue");
            }
            baos.write(bytes);
            baos.write(this.content);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void saveToFile(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(this.getFileContent());
        fos.close();
        System.out.println("Saved to " + fileName);
    }

    public static byte[] extractContent(byte[] rom) {
        if (rom.length < BIN_HEADER.length()) {
            return null;
        }
        byte[] result = new byte[rom.length - BIN_HEADER.length()];
        System.arraycopy(rom, BIN_HEADER.length(), result, 0, result.length);
        return result;
    }

    public byte[] getContent() {
        return this.content;
    }

    public ConfigurationImage clone() {
        byte[] copy = (byte[])this.content.clone();
        return new ConfigurationImage(copy);
    }

    public byte[] getRange(Integer first, int size) {
        byte[] r = new byte[size];
        System.arraycopy(this.content, first, r, 0, size);
        return r;
    }
}

