/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

public class CyclicBuffer {
    private final double[] values;
    private int size = 0;
    private int pointer = 0;

    public CyclicBuffer(int maxSize) {
        this.values = new double[maxSize];
    }

    public double getStandardDeviation() {
        double accumulator = 0.0;
        double avg = this.average();
        for (int i = 0; i < this.getSize(); ++i) {
            double v = this.get(i) - avg;
            accumulator += v * v;
        }
        return Math.sqrt(accumulator);
    }

    public void add(double value) {
        if (this.size < this.values.length) {
            ++this.size;
        }
        this.values[this.pointer] = value;
        ++this.pointer;
        if (this.pointer == this.values.length) {
            this.pointer = 0;
        }
    }

    public double average() {
        return this.sum() / (double)this.size;
    }

    public double sum() {
        double result = 0.0;
        for (int i = 0; i < this.size; ++i) {
            result += this.values[i];
        }
        return result;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxSize() {
        return this.values.length;
    }

    public double get(int i) {
        return this.values[i];
    }
}

