/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.StimulationInputs;
import com.rusefi.core.EngineTimeListener;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.file.TableGenerator;
import com.rusefi.io.LinkManager;
import com.rusefi.models.Point3D;
import com.rusefi.models.Range;
import com.rusefi.models.XYData;
import com.rusefi.ui.ChartHelper;
import com.rusefi.ui.RpmModel;
import com.rusefi.ui.widgets.PotCommand;
import com.rusefi.ui.widgets.RpmCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.ericaro.surfaceplotter.DefaultSurfaceModel;

public class EcuStimulator {
    private static final String DELIMITER = ",";
    private static final long SLEEP_TIME = 300L;
    private static final double EPS = 0.001;
    public boolean isDisplayingFuel = true;
    private static final Sensor DWELL_SENSOR = Sensor.DWELL0;
    public static final Sensor ADVANCE_SENSOR = Sensor.ADVANCE0;
    private static final int MEASURES = 7;
    private static final String C_PREFIX = "fuel_";
    public static Range RPM_RANGE = new Range(0.0f, 7000.0f);
    private StimulationInputs inputs = new StimulationInputs(this);
    private XYData data = new XYData();
    private DefaultSurfaceModel model = ChartHelper.createDefaultSurfaceModel(this.data, RPM_RANGE, new Range(1.0f, 5.0f));
    private final JPanel content = new JPanel(new BorderLayout());
    private static EcuStimulator instance = new EcuStimulator();
    private final JLabel statusLabel = new JLabel();

    private EcuStimulator() {
        JPanel panel = ChartHelper.create3DControl(this.data, this.model, this.isDisplayingFuel ? "Fuel Table" : "Timing");
        this.content.add((Component)this.statusLabel, "North");
        this.content.add((Component)panel, "Center");
        this.content.add((Component)this.inputs.getContent(), "South");
    }

    public static EcuStimulator getInstance() {
        return instance;
    }

    public JPanel getPanel() {
        return this.content;
    }

    public void buildTable() {
        BufferedWriter csv;
        this.data.clear();
        String csvFileName = "table_" + this.inputs.getRpmStep() + "_" + this.inputs.getEngineLoadStep() + FileLog.getDate() + ".csv";
        FileLog.MAIN.logLine("Wring to " + csvFileName);
        try {
            csv = new BufferedWriter(new FileWriter(csvFileName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ResultListener listener = new ResultListener(){

            @Override
            public void onResult(int rpm, double engineLoad, double advance, double dwell) {
                EcuStimulator.this.data.addPoint(new Point3D(rpm, engineLoad, EcuStimulator.this.isDisplayingFuel ? (float)dwell : (float)advance));
                EcuStimulator.this.model.plot().execute();
                String msg = EcuStimulator.putValue("rpm", rpm) + EcuStimulator.putValue("engine_load", engineLoad) + EcuStimulator.putValue("advance", advance) + EcuStimulator.putValue("dwell", dwell);
                MessagesCentral.getInstance().postMessage(EcuStimulator.class, msg);
                try {
                    csv.write(msg + "\r\n");
                    csv.flush();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        ChartHelper.setYRange(new Range(this.inputs.getEngineLoadMin(), this.inputs.getEngineLoadMax()), this.model);
        this.buildTable(listener, DWELL_SENSOR);
        try {
            csv.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        TableGenerator.writeAsC(this.data, C_PREFIX, "map" + FileLog.getDate() + ".c");
    }

    private void buildTable(ResultListener listener, Sensor dwellSensor) {
        for (double rpm = this.inputs.getRpmFrom(); rpm <= this.inputs.getRpmTo() + 0.001; rpm += this.inputs.getRpmStep()) {
            for (double engineLoad = this.inputs.getEngineLoadMin(); engineLoad <= this.inputs.getEngineLoadMax() + 0.001; engineLoad += this.inputs.getEngineLoadStep()) {
                for (int clt = this.inputs.getCltFrom(); clt <= this.inputs.getCltTo(); clt += 100) {
                    this.testPoint((int)rpm, engineLoad, clt, listener, dwellSensor);
                }
            }
        }
    }

    private void testPoint(int rpm, double engineLoad, int clt, ResultListener resultListener, Sensor dwellSensor) {
        EcuStimulator.setPotVoltage(engineLoad, null);
        EcuStimulator.setRpm(rpm);
        EcuStimulator.sleepRuntime(300L);
        this.statusLabel.setText("RPM " + rpm + ", el " + engineLoad + ", CLT " + clt);
        MultipleMeasurements r = this.waitForMultipleResults(dwellSensor, ADVANCE_SENSOR);
        List<Double> dwells = r.getDwells();
        List<Double> advances = r.getAdvances();
        Collections.sort(dwells);
        Collections.sort(advances);
        double dwellDiff = Math.abs(dwells.get(0) - dwells.get(6));
        if (dwellDiff > 1.0) {
            System.out.println("dwells " + dwells);
        }
        double dwell = dwells.get(3);
        double advance = advances.get(3);
        EcuStimulator.log("Stimulator result: " + rpm + "@" + engineLoad + ": " + dwell + ", adv=" + advance);
        resultListener.onResult(rpm, engineLoad, (float)advance, dwell);
    }

    private static void sleepRuntime(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static double getValue(Sensor sensor) {
        return SensorCentral.getInstance().getValue(sensor);
    }

    private static void setRpm(int rpm) {
        int actual;
        int attempt = 0;
        do {
            RpmCommand.requestRpmChange(rpm);
            EcuStimulator.sleepRuntime(50L);
            actual = RpmModel.getInstance().getValue();
        } while (attempt++ < 10 && Math.abs(rpm - actual) >= 100);
        EcuStimulator.log("Result: " + actual + " while setting " + rpm);
    }

    public static void setPotVoltage(double targetVoltage, Sensor sensor) {
        if (sensor != null) {
            EcuStimulator.log("Current targetVoltage: " + EcuStimulator.getValue(sensor) + ", setting " + targetVoltage);
        }
        int attempt = 0;
        double vRef = EcuStimulator.getVRef();
        int resistance = PotCommand.getPotResistance(targetVoltage, vRef);
        if (resistance <= 0) {
            EcuStimulator.log("Invalid resistance " + resistance + ". Invalid targetVoltage " + targetVoltage + "?");
            return;
        }
        if (sensor == null) {
            PotCommand.requestPotChange(1, resistance);
            EcuStimulator.sleepRuntime(1000L);
        } else {
            double actual;
            do {
                PotCommand.requestPotChange(1, resistance);
                EcuStimulator.sleepRuntime(50L);
                actual = EcuStimulator.getValue(sensor);
                EcuStimulator.log("Got: " + actual + " on attempt=" + attempt + " while setting " + targetVoltage + " for " + (Object)((Object)sensor));
            } while (attempt++ < 10 && Math.abs(targetVoltage - actual) > 0.2);
            EcuStimulator.log("Result: " + actual + " while setting " + targetVoltage);
        }
    }

    private static double getVRef() {
        return 4.7;
    }

    private static void log(String message) {
        MessagesCentral.getInstance().postMessage(EcuStimulator.class, message);
        FileLog.MAIN.logLine(message);
    }

    private static String putValue(String msg, double value) {
        return msg + DELIMITER + value + DELIMITER;
    }

    private static String putValue(String msg, int value) {
        return msg + DELIMITER + value + DELIMITER;
    }

    public JButton createButton() {
        final JButton button = new JButton("stimulate stock ECU");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EcuStimulator.this.buildTable();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            System.exit(-20);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                button.setText("Done");
                            }
                        });
                    }
                }, "Ecu Stimulator").start();
            }
        });
        return button;
    }

    public StimulationInputs getInputs() {
        return this.inputs;
    }

    public MultipleMeasurements waitForMultipleResults(final Sensor dwellSensor, final Sensor advanceSensor) {
        final MultipleMeasurements result = new MultipleMeasurements();
        final CountDownLatch latch = new CountDownLatch(7);
        EngineTimeListener listener = new EngineTimeListener(){

            @Override
            public void onTime(double time) {
                if (latch.getCount() == 0L) {
                    return;
                }
                double dwell = EcuStimulator.getValue(dwellSensor);
                double advance = EcuStimulator.getValue(advanceSensor);
                advance = Sensor.processAdvance(advance);
                result.dwells.add(dwell);
                result.advances.add(advance);
                latch.countDown();
            }
        };
        LinkManager.engineState.timeListeners.add(listener);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        LinkManager.engineState.timeListeners.remove(listener);
        return result;
    }

    private class MultipleMeasurements {
        private List<Double> dwells = new ArrayList<Double>(7);
        private List<Double> advances = new ArrayList<Double>(7);

        private MultipleMeasurements() {
        }

        public List<Double> getDwells() {
            return this.dwells;
        }

        public List<Double> getAdvances() {
            return this.advances;
        }
    }

    static interface ResultListener {
        public void onResult(int var1, double var2, double var4, double var6);
    }
}

