/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AutoTest;
import com.rusefi.FileLog;
import com.rusefi.IoUtil;
import com.rusefi.RealHwTest;

public class EnduranceTest {
    private static final int DEFAULT_COUNT = 2000;

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        int count = EnduranceTest.parseCount(args);
        try {
            String port = RealHwTest.startRealHardwareTest(args);
            if (port == null) {
                System.out.println("EnduranceTest [SERIAL] [COUNT]");
                return;
            }
            FileLog.MAIN.logLine("Running " + count + " cycles");
            IoUtil.realHardwareConnect(port);
            for (int i = 0; i < count; ++i) {
                AutoTest.currentEngineType = 3;
                IoUtil.sendCommand("set_engine_type 3", 10000, 60);
                IoUtil.sleep(2);
                IoUtil.sendCommand("enable self_stimulation");
                AutoTest.currentEngineType = 28;
                IoUtil.sendCommand("set_engine_type 28", 10000, 60);
                IoUtil.sleep(2);
                FileLog.MAIN.logLine("++++++++++++++++++++++++++++++++++++  " + i + "   +++++++++++++++");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
        FileLog.MAIN.logLine("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        FileLog.MAIN.logLine("++++++++++++++++++++++++++++++++++++  YES YES YES " + count + "   +++++++++++++++");
        FileLog.MAIN.logLine("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        long totalTime = System.currentTimeMillis() - start;
        long minutes = totalTime / 1000L / 60L;
        FileLog.MAIN.logLine("In " + minutes + " minutes");
    }

    private static int parseCount(String[] args) {
        if (args.length == 2) {
            return Integer.parseInt(args[1]);
        }
        return 2000;
    }
}

