/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public enum FileLog {
    MAIN,
    SIMULATOR_CONSOLE;

    public static final String DIR = "out/";
    public static String currentLogName;
    public static final String END_OF_TIMESTAND_TAG = "<EOT>: ";
    public static final Logger LOGGER;
    @Nullable
    private OutputStream fileLog;
    public static boolean suspendLogging;

    public void start() {
        if (this.fileLog != null) {
            return;
        }
        try {
            this.fileLog = this.openLog();
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private FileOutputStream openLog() throws FileNotFoundException {
        String date = FileLog.getDate();
        FileLog.createFolderIfNeeded();
        currentLogName = this.name() + "_rfi_report_" + date + ".csv";
        String fileName = DIR + currentLogName;
        FileLog.rlog("Writing to " + fileName);
        return new FileOutputStream(fileName, true);
    }

    private static void createFolderIfNeeded() {
        File dir = new File(DIR);
        if (dir.exists()) {
            return;
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new IllegalStateException("Failed to create out/ folder");
        }
    }

    public static String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss").format(new Date());
    }

    public synchronized void logLine(String fullLine) {
        System.out.println(fullLine);
        if (suspendLogging) {
            return;
        }
        if (this.fileLog == null) {
            return;
        }
        try {
            this.fileLog.write((new Date() + END_OF_TIMESTAND_TAG + fullLine + "\r\n").getBytes());
            this.fileLog.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void close() {
        if (this.fileLog == null) {
            return;
        }
        try {
            FileLog.rlog("Closing file...");
            this.fileLog.close();
            this.fileLog = null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void rlog(String msg) {
        System.out.println("rlog " + msg);
    }

    public void log(IllegalStateException exception) {
        if (this.fileLog == null) {
            throw new NullPointerException("fileLog");
        }
        OutputStreamWriter os = new OutputStreamWriter(this.fileLog);
        exception.printStackTrace(new PrintWriter(os));
    }

    public void logException(String msg, Throwable e) {
        this.logLine(msg + e);
        e.printStackTrace();
    }

    static {
        LOGGER = new Logger(){

            @Override
            public void trace(String msg) {
            }

            @Override
            public void info(String msg) {
                MAIN.logLine(msg);
            }

            @Override
            public void error(String msg) {
                MAIN.logLine(msg);
            }
        };
    }
}

