/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FiringOrderTSLogic {
    private static final String FIRING_ORDER_PREFIX = "FO_";
    private static final Map<Integer, String[]> ordinal2order = new HashMap<Integer, String[]>();

    public static void main(String[] args) throws IOException {
        FiringOrderTSLogic.readFiringOrders();
        for (int i = 2; i <= 12; ++i) {
            FiringOrderTSLogic.processId(i);
        }
    }

    private static void readFiringOrders() throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader("../firmware/controllers/algo/firing_order.h"));
        while ((line = br.readLine()) != null) {
            int index = line.indexOf(FIRING_ORDER_PREFIX);
            if (index == -1) {
                System.out.println("Skipping [" + line);
                continue;
            }
            line = line.substring(index + FIRING_ORDER_PREFIX.length());
            line = line.replaceAll("[\\s\\,]", "");
            System.out.println("Processing " + line);
            String[] s = line.split("\\=");
            Object[] order = s[0].split("_");
            int ordinal = Integer.parseInt(s[1]);
            System.out.println("order " + Arrays.toString(order) + ": " + ordinal);
            ordinal2order.put(ordinal, (String[])order);
        }
    }

    private static void processId(int cylinderId) {
        StringBuilder logic = new StringBuilder();
        for (Map.Entry<Integer, String[]> e : ordinal2order.entrySet()) {
            Integer ordinal = e.getKey();
            String[] order = e.getValue();
            if (order.length % 2 != 0) continue;
            int halfSize = order.length / 2;
            boolean allowed = false;
            for (int i = 0; i < halfSize; ++i) {
                allowed |= order[i].equals(Integer.toString(cylinderId));
            }
            if (!allowed) continue;
            if (logic.length() > 0) {
                logic.append(" || ");
            }
            logic.append("(firingOrder == ").append(ordinal).append(")");
        }
        String result = logic.length() == 0 ? "" : "|| (" + logic + ")";
        System.out.println("#define ignitionPin" + cylinderId + "logic " + result + "");
    }
}

