/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Histograms {
    private static final String SQL_STATEMENT = "SQL-statement";
    public static final double H_ACCURACY = 0.05;
    public static final int BOUND_LENGTH = (int)(Math.log(9.223372036854776E18) / Math.log(1.05));
    public static final long LONG_MAX_INT = Long.MAX_VALUE;
    public static final double H_CONFIDENCE = 0.8;
    public static final int SBI_SIZE = 1000;
    private final HashMap<String, StatisticsGroup> total_stats = new HashMap();
    private final long start_time = System.currentTimeMillis();
    public final ThreadLocal<LocalStats> local_stats = new ThreadLocal<LocalStats>(){

        @Override
        protected LocalStats initialValue() {
            return new LocalStats();
        }
    };
    private final HashSet<LocalStats> all_local_stats = new HashSet();
    private long last_dump = System.currentTimeMillis();
    private final double[] confidence_bounds;
    private final String[] confidence_separators;
    private final long[] bounds;
    private final int[] small_bounds_index;
    private static final double[] multipliers = new double[]{1.0, 10.0, 100.0};
    private final NumberFormat formatter = NumberFormat.getNumberInstance();
    private final FieldPosition field = new FieldPosition(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> dumpStats() {
        Collection<StatisticsGroup> values = this.takeAndResetSnapshot();
        ArrayList<StatisticsGroup> al = new ArrayList<StatisticsGroup>();
        al.addAll(values);
        HashMap<String, StatisticsGroup> hashMap = this.total_stats;
        synchronized (hashMap) {
            for (StatisticsGroup source : values) {
                String type = source.type + ".TOTAL";
                StatisticsGroup dest = this.total_stats.get(type);
                if (dest == null) {
                    dest = new StatisticsGroup(type);
                    this.total_stats.put(type, dest);
                }
                dest.add(source);
            }
            al.addAll(this.total_stats.values());
        }
        return this.sortAndAddTimes(al);
    }

    @NotNull
    public List<String> getCurrentStatistics() {
        Collection<StatisticsGroup> snapshot = this.getCurrentSnapshot();
        return this.sortAndAddTimes(new ArrayList<StatisticsGroup>(snapshot));
    }

    private List<String> sortAndAddTimes(List<StatisticsGroup> al) {
        Collections.sort(al, new Comparator<StatisticsGroup>(){

            @Override
            public int compare(StatisticsGroup o1, StatisticsGroup o2) {
                return o1.type.compareTo(o2.type);
            }
        });
        long time = System.currentTimeMillis();
        ArrayList<String> result = new ArrayList<String>();
        for (StatisticsGroup sg : al) {
            result.add(this.toString(sg, time - (sg.type.endsWith(".TOTAL") ? this.start_time : this.last_dump)));
        }
        this.last_dump = time;
        return result;
    }

    public Histograms() {
        int i;
        this.confidence_bounds = new double[]{0.09999999999999998, 0.5, 0.9};
        this.confidence_separators = new String[]{"(", " [", "-", "-", "] ", ")"};
        FileLog.MAIN.logLine("BOUND_LENGTH=" + BOUND_LENGTH);
        this.bounds = new long[BOUND_LENGTH];
        this.bounds[0] = 0L;
        for (i = 1; i < BOUND_LENGTH; ++i) {
            long prev = this.bounds[i - 1];
            long next = prev + (long)((double)prev * 0.05);
            if (next == prev) {
                next = prev + 1L;
            }
            if (next < prev) {
                next = Long.MAX_VALUE;
            }
            this.bounds[i] = next;
        }
        this.bounds[Histograms.BOUND_LENGTH - 1] = Long.MAX_VALUE;
        this.small_bounds_index = new int[1000];
        i = 0;
        int j = 0;
        while (j < 1000) {
            while ((long)j < this.bounds[i + 1] && j < 1000) {
                this.small_bounds_index[j++] = i;
            }
            ++i;
        }
    }

    public int getIndex(long value) {
        if (value < 0L) {
            return 0;
        }
        if (value < (long)this.small_bounds_index.length) {
            return this.small_bounds_index[(int)value];
        }
        int l = this.small_bounds_index[this.small_bounds_index.length - 1];
        int r = this.bounds.length - 1;
        while (l < r) {
            int m = l + r >> 1;
            if (this.bounds[m] > value) {
                r = m - 1;
                continue;
            }
            if (this.bounds[m + 1] <= value) {
                l = m + 1;
                continue;
            }
            return m;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(ValueType t, String name, long value) {
        StatisticsGroup sg;
        boolean create;
        String type = t.getName();
        if (value < 0L) {
            value = 0L;
        }
        int index = this.getIndex(value);
        LocalStats ls = this.local_stats.get();
        boolean bl = create = ls.stats == null;
        if (create) {
            ls.stats = new HashMap();
        }
        if ((sg = ls.stats.get((Object)t)) == null) {
            sg = new StatisticsGroup(type);
            ls.stats.put(t, sg);
        }
        sg.add(name, index, value);
        if (create) {
            HashSet<LocalStats> hashSet = this.all_local_stats;
            synchronized (hashSet) {
                this.all_local_stats.add(ls);
            }
        }
    }

    private Collection<StatisticsGroup> getCurrentSnapshot() {
        List<LocalStats> lss = this.getLocalStats(false);
        HashMap<String, StatisticsGroup> snapshot = new HashMap<String, StatisticsGroup>();
        for (LocalStats ls : lss) {
            Histograms.mergeStats(snapshot, ls.stats);
        }
        return snapshot.values();
    }

    private Collection<StatisticsGroup> takeAndResetSnapshot() {
        List<LocalStats> lss = this.getLocalStats(true);
        HashMap<String, StatisticsGroup> snapshot = new HashMap<String, StatisticsGroup>();
        for (LocalStats ls : lss) {
            HashMap<ValueType, StatisticsGroup> stats = ls.stats;
            ls.stats = null;
            Histograms.mergeStats(snapshot, stats);
        }
        return snapshot.values();
    }

    private static void mergeStats(HashMap<String, StatisticsGroup> snapshot, HashMap<ValueType, StatisticsGroup> stats) {
        if (stats != null) {
            for (StatisticsGroup source : stats.values()) {
                StatisticsGroup dest = snapshot.get(source.type);
                if (dest == null) {
                    snapshot.put(source.type, source);
                    continue;
                }
                dest.add(source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocalStats> getLocalStats(boolean reset) {
        ArrayList<LocalStats> lss;
        HashSet<LocalStats> hashSet = this.all_local_stats;
        synchronized (hashSet) {
            lss = new ArrayList<LocalStats>(this.all_local_stats);
            if (reset) {
                this.all_local_stats.clear();
            }
        }
        return lss;
    }

    private static void sortStatistics(StatisticsGroup sg, Statistics[] sts) {
        final boolean use_total = sg.type.startsWith(SQL_STATEMENT);
        Arrays.sort(sts, new Comparator<Statistics>(){

            @Override
            public int compare(Statistics st1, Statistics st2) {
                if (use_total && st1.total_value != st2.total_value) {
                    return st1.total_value < st2.total_value ? -1 : 1;
                }
                return st1.name.compareTo(st2.name);
            }
        });
    }

    private StringBuffer format(double d, StringBuffer sb) {
        int i = Math.abs(d) < 9.995 ? 2 : (Math.abs(d) < 99.95 ? 1 : 0);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(i);
        return this.formatter.format(Math.floor(d * multipliers[i] + 0.5) / multipliers[i], sb, this.field);
    }

    private void appendHeader(StringBuffer sb, StatisticsGroup sg, long duration) {
        double time = duration;
        String time_scale = "ms";
        if (time >= 8.5968E7) {
            time /= 8.64E7;
            time_scale = "days";
        } else if (time >= 3582000.0) {
            time /= 3600000.0;
            time_scale = "hours";
        } else if (time >= 59700.0) {
            time /= 60000.0;
            time_scale = "min";
        } else if (time >= 995.0) {
            time /= 1000.0;
            time_scale = "sec";
        }
        sb.append(sg.type).append(" statistics for ");
        this.format(time, sb).append(time_scale).append(" with ");
        this.format(5.0, sb).append("% accuracy and ");
        this.format(80.0, sb).append("% confidence:");
    }

    public void appendStatistics(StringBuffer sb, Statistics st, List<Long> report) {
        this.format(st.total_value, sb).append(" / ").append(st.total_count).append(" = ");
        this.format((double)st.total_value / (double)st.total_count, sb);
        if (st.total_count < 0L) {
            sb.append("Total count is less then ZERO!\n");
            return;
        }
        if (st.total_count <= 5L) {
            sb.append(" are");
            for (int j = 0; j < st.histogram.length; ++j) {
                int k = 0;
                while ((long)k < st.histogram[j]) {
                    sb.append(' ');
                    this.format((this.bounds[j] + this.bounds[j + 1]) / 2L, sb);
                    ++k;
                }
            }
            return;
        }
        sb.append(" in ").append(this.confidence_separators[0]);
        int min = 0;
        while (st.histogram[min] == 0L) {
            ++min;
        }
        this.format(this.bounds[min], sb).append(this.confidence_separators[1]);
        report.add(this.bounds[min]);
        long acc = 0L;
        for (int j = 0; j < this.confidence_bounds.length; ++j) {
            long k = (long)Math.floor((double)st.total_count * this.confidence_bounds[j]);
            if (k == 0L) {
                k = 1L;
            }
            if (k == st.total_count) {
                k = st.total_count - 1L;
            }
            while (acc + st.histogram[min] < k) {
                acc += st.histogram[min++];
            }
            if (k < st.total_count / 2L) {
                while (acc + st.histogram[min] <= k) {
                    acc += st.histogram[min++];
                }
            }
            double d = this.bounds[min];
            if (acc != k) {
                d += (double)(this.bounds[min + 1] - 1L - this.bounds[min]) * (double)(k - acc) / (double)st.histogram[min];
            }
            this.format(d, sb).append(this.confidence_separators[j + 2]);
            report.add((long)d);
        }
        int max = st.histogram.length - 1;
        while (st.histogram[max] == 0L) {
            --max;
        }
        long maxValue = this.bounds[max + 1] - 1L;
        this.format(maxValue, sb).append(this.confidence_separators[5]);
        report.add(maxValue);
    }

    private String toString(StatisticsGroup sg, long duration) {
        StringBuffer sb = new StringBuffer(100 + sg.data.size() * 100);
        this.appendHeader(sb, sg, duration);
        Statistics[] sts = sg.data.values().toArray(new Statistics[sg.data.size()]);
        Histograms.sortStatistics(sg, sts);
        for (Statistics st : sts) {
            this.appendStatistics(sb, st, new ArrayList<Long>());
        }
        return sb.toString();
    }

    public static enum ValueType {
        INVOCATION("Invocation");

        private final String name;

        public String getName() {
            return this.name;
        }

        private ValueType(String name) {
            this.name = name;
        }
    }

    public static class StatisticsGroup {
        public final String type;
        public final HashMap<String, Statistics> data;

        private StatisticsGroup(String type) {
            this.type = type;
            this.data = new HashMap();
        }

        public void add(String name, int index, long value) {
            Statistics st = this.data.get(name);
            if (st == null) {
                st = new Statistics(name);
                this.data.put(name, st);
            }
            st.add(index, 1, value);
        }

        public void add(StatisticsGroup sg) {
            for (Statistics source : sg.data.values()) {
                Statistics dest = this.data.get(source.name);
                if (dest == null) {
                    this.data.put(source.name, new Statistics(source));
                    continue;
                }
                dest.add(source);
            }
        }
    }

    public static class Statistics {
        private static final long[] EMPTY_HISTOGRAM = new long[0];
        public final String name;
        public long total_value;
        public long total_count;
        public long[] histogram;

        private Statistics(String name) {
            this.name = name;
            this.histogram = EMPTY_HISTOGRAM;
        }

        private Statistics(Statistics st) {
            this.name = st.name;
            this.total_value = st.total_value;
            this.total_count = st.total_count;
            this.histogram = st.histogram.length == 0 ? EMPTY_HISTOGRAM : (long[])st.histogram.clone();
        }

        public void add(int index, int count, long value) {
            this.total_value += value;
            this.total_count += (long)count;
            if (index >= this.histogram.length) {
                int new_length;
                for (new_length = Math.max(this.histogram.length, 10); index >= new_length; new_length <<= 1) {
                }
                long[] new_histogram = new long[new_length];
                System.arraycopy(this.histogram, 0, new_histogram, 0, this.histogram.length);
                this.histogram = new_histogram;
            }
            int n = index;
            this.histogram[n] = this.histogram[n] + (long)count;
        }

        public void add(Statistics st) {
            this.total_value += st.total_value;
            this.total_count += st.total_count;
            long[] hist = st.histogram;
            if (this.histogram.length < st.histogram.length) {
                hist = this.histogram;
                this.histogram = (long[])st.histogram.clone();
            }
            int i = hist.length;
            while (--i >= 0) {
                int n = i;
                this.histogram[n] = this.histogram[n] + hist[i];
            }
        }
    }

    public static final class LocalStats {
        public HashMap<ValueType, StatisticsGroup> stats;
    }
}

