/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.ExecHelper;
import com.rusefi.FileLog;
import com.rusefi.core.EngineState;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.waves.EngineReport;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import jssc.SerialPortList;

public class IoUtil {
    public static final String RESET_ENGINE_CHART = "reset_engine_chart";

    static void sendCommand(String command) {
        IoUtil.sendCommand(command, 500, 20);
    }

    static void sendCommand(String command, int retryTimeoutMs, int totalTimeoutSeconds) {
        final CountDownLatch responseLatch = new CountDownLatch(1);
        long time = System.currentTimeMillis();
        if (LinkManager.hasError()) {
            throw new IllegalStateException("IO error");
        }
        FileLog.MAIN.logLine("Sending command [" + command + "]");
        final long begin = System.currentTimeMillis();
        CommandQueue.getInstance().write(command, retryTimeoutMs, new InvocationConfirmationListener(){

            @Override
            public void onCommandConfirmation() {
                responseLatch.countDown();
                FileLog.MAIN.logLine("Got confirmation in " + (System.currentTimeMillis() - begin) + "ms");
            }
        });
        IoUtil.wait(responseLatch, totalTimeoutSeconds);
        if (responseLatch.getCount() > 0L) {
            FileLog.MAIN.logLine("No confirmation in " + retryTimeoutMs);
        }
        if (LinkManager.hasError()) {
            throw new IllegalStateException("IO error");
        }
        FileLog.MAIN.logLine("Command [" + command + "] executed in " + (System.currentTimeMillis() - time));
    }

    static void wait(CountDownLatch responseLatch, int seconds) {
        try {
            responseLatch.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    static void changeRpm(final int rpm) {
        IoUtil.sendCommand("rpm " + rpm);
        long time = System.currentTimeMillis();
        final CountDownLatch rpmLatch = new CountDownLatch(1);
        SensorCentral.SensorListener listener = new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                double actualRpm = SensorCentral.getInstance().getValue(Sensor.RPM);
                if (EngineReport.isCloseEnough(rpm, actualRpm)) {
                    rpmLatch.countDown();
                }
            }
        };
        SensorCentral.getInstance().addListener(Sensor.RPM, listener);
        try {
            rpmLatch.await(40L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        FileLog.MAIN.logLine("RPM change [" + rpm + "] executed in " + (System.currentTimeMillis() - time));
        SensorCentral.getInstance().removeListener(Sensor.RPM, listener);
        double actualRpm = SensorCentral.getInstance().getValue(Sensor.RPM);
        if (!EngineReport.isCloseEnough(rpm, actualRpm)) {
            throw new IllegalStateException("rpm change did not happen: " + rpm + ", actual " + actualRpm);
        }
        IoUtil.sendCommand(RESET_ENGINE_CHART);
    }

    static void waitForFirstResponse() throws InterruptedException {
        FileLog.MAIN.logLine("Let's give it some time to start...");
        final CountDownLatch startup = new CountDownLatch(1);
        SensorCentral.SensorListener listener = new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                startup.countDown();
            }
        };
        long waitStart = System.currentTimeMillis();
        SensorCentral.getInstance().addListener(Sensor.RPM, listener);
        startup.await(5L, TimeUnit.SECONDS);
        SensorCentral.getInstance().removeListener(Sensor.RPM, listener);
        FileLog.MAIN.logLine("Got first signal in " + (System.currentTimeMillis() - waitStart));
    }

    static void launchSimulator(boolean startProcess) throws InterruptedException {
        if (startProcess) {
            if (!TcpConnector.getAvailablePorts().isEmpty()) {
                throw new IllegalStateException("Port already binded on startup?");
            }
            ExecHelper.startSimulator();
        }
        LinkManager.start("29001");
        LinkManager.open();
        LinkManager.engineState.registerStringValueAction("rusEfiVersion", EngineState.ValueCallback.VOID);
        IoUtil.waitForFirstResponse();
    }

    static void sleep(int seconds) {
        FileLog.MAIN.logLine("Sleeping " + seconds + " seconds");
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    static String getDefaultPort() {
        String[] ports = SerialPortList.getPortNames();
        if (ports.length == 0) {
            System.out.println("Port not specified and no ports found");
            return null;
        }
        String port = ports[ports.length - 1];
        System.out.println("Using last of " + ports.length + " port(s)");
        return port;
    }

    static void realHardwareConnect(String port) {
        LinkManager.start(port);
        final CountDownLatch connected = new CountDownLatch(1);
        LinkManager.open(new LinkManager.LinkStateListener(){

            @Override
            public void onConnectionFailed() {
                System.out.println("CONNECTION FAILED, did you specify the right port name?");
                System.exit(-1);
            }

            @Override
            public void onConnectionEstablished() {
                connected.countDown();
            }
        });
        LinkManager.engineState.registerStringValueAction("rusEfiVersion", EngineState.ValueCallback.VOID);
        LinkManager.engineState.registerStringValueAction("outpin", EngineState.ValueCallback.VOID);
        LinkManager.engineState.registerStringValueAction("analog_chart", EngineState.ValueCallback.VOID);
        try {
            connected.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (connected.getCount() > 0L) {
            throw new IllegalStateException("Not connected in time");
        }
    }
}

