/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.BenchTestPane;
import com.rusefi.FileLog;
import com.rusefi.SensorLogger;
import com.rusefi.SensorSnifferPane;
import com.rusefi.SimulatorHelper;
import com.rusefi.StartupFrame;
import com.rusefi.TableEditorPane;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.EngineState;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.ConnectionStatus;
import com.rusefi.io.ConnectionWatchdog;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.PortHolder;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.maintenance.VersionChecker;
import com.rusefi.ui.FormulasPane;
import com.rusefi.ui.FuelTunePane;
import com.rusefi.ui.GaugesPanel;
import com.rusefi.ui.LogDownloader;
import com.rusefi.ui.MessagesPane;
import com.rusefi.ui.SettingsTab;
import com.rusefi.ui.engine.EngineSnifferPanel;
import com.rusefi.ui.logview.LogViewer;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.storage.PersistentConfiguration;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.FrameHelper;
import com.rusefi.ui.util.JustOneInstance;
import com.rusefi.ui.util.UiUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jssc.SerialPortList;

public class Launcher {
    public static final int CONSOLE_VERSION = 20170108;
    public static final boolean SHOW_STIMULATOR = false;
    private static final String TAB_INDEX = "main_tab";
    protected static final String PORT_KEY = "port";
    protected static final String SPEED_KEY = "speed";
    public static final String FATAL_ERROR_PREFIX = "FATAL";
    private final String port;
    private String fatalError;
    public static EngineSnifferPanel engineSnifferPanel;
    private static SensorCentral.SensorListener wrongVersionListener;
    private final JTabbedPane tabbedPane = new JTabbedPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.paintStatusText(g);
        }

        private void paintStatusText(Graphics g) {
            String text;
            Font f = g.getFont();
            g.setFont(new Font(f.getName(), f.getStyle(), f.getSize() * 4));
            Dimension d = this.getSize();
            switch (ConnectionStatus.INSTANCE.getValue()) {
                case NOT_CONNECTED: {
                    text = "Not connected";
                    break;
                }
                case LOADING: {
                    text = "Loading";
                    break;
                }
                default: {
                    text = "";
                }
            }
            if (Launcher.this.fatalError != null) {
                text = Launcher.this.fatalError;
                g.setColor(Color.red);
            }
            int labelWidth = g.getFontMetrics().stringWidth(text);
            g.drawString(text, (d.width - labelWidth) / 2, d.height / 2);
        }
    };
    public static AtomicReference<String> firmwareVersion;
    private static Frame staticFrame;
    private final TableEditorPane tableEditor = new TableEditorPane();
    private final SettingsTab settingsTab = new SettingsTab();
    private final LogDownloader logsManager = new LogDownloader();
    private final FuelTunePane fuelTunePane;
    private FrameHelper mainFrame = new FrameHelper(){

        @Override
        protected void onWindowOpened() {
            super.onWindowOpened();
            Launcher.this.windowOpenedHandler();
        }

        @Override
        protected void onWindowClosed() {
            Launcher.this.windowClosedHandler();
            super.onWindowClosed();
        }
    };

    public Launcher(String port) {
        int selectedIndex;
        this.port = port;
        staticFrame = this.mainFrame.getFrame();
        FileLog.MAIN.logLine("Console 20170108");
        PersistentConfiguration.getConfig().getRoot().setProperty(PORT_KEY, port);
        PersistentConfiguration.getConfig().getRoot().setProperty(SPEED_KEY, PortHolder.BAUD_RATE);
        LinkManager.start(port);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                if (message.startsWith(Launcher.FATAL_ERROR_PREFIX)) {
                    Launcher.this.fatalError = message;
                }
            }
        });
        engineSnifferPanel = new EngineSnifferPanel(PersistentConfiguration.getConfig().getRoot().getChild("digital_sniffer"));
        if (!LinkManager.isLogViewerMode(port)) {
            engineSnifferPanel.setOutpinListener(LinkManager.engineState);
        }
        if (LinkManager.isLogViewerMode(port)) {
            this.tabbedPane.add("Log Viewer", new LogViewer(engineSnifferPanel));
        }
        ConnectionWatchdog.start();
        GaugesPanel.DetachedRepository.INSTANCE.init(PersistentConfiguration.getConfig().getRoot().getChild("detached"));
        GaugesPanel.DetachedRepository.INSTANCE.load();
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.addTab("Gauges", new GaugesPanel(PersistentConfiguration.getConfig().getRoot().getChild("gauges")).getContent());
        }
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.addTab("Formulas", new FormulasPane().getContent());
        }
        this.tabbedPane.addTab("Engine Sniffer", engineSnifferPanel.getPanel());
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.addTab("Sensor Sniffer", new SensorSnifferPane(PersistentConfiguration.getConfig().getRoot().getChild("sensor_sniffer")).getPanel());
        }
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.add("Messages", new MessagesPane(PersistentConfiguration.getConfig().getRoot().getChild("messages")).getContent());
        }
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.addTab("Table Editor", this.tableEditor);
        }
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.add("Settings", this.settingsTab.createPane());
        }
        if (!LinkManager.isLogViewer()) {
            this.tabbedPane.add("Bench Test", new BenchTestPane().getContent());
        }
        if (!LinkManager.isLogViewer()) {
            // empty if block
        }
        this.fuelTunePane = new FuelTunePane(PersistentConfiguration.getConfig().getRoot().getChild("fueltune"));
        this.tabbedPane.add("Fuel Tune", this.fuelTunePane.getContent());
        if (!LinkManager.isLogViewerMode(port) && (selectedIndex = PersistentConfiguration.getConfig().getRoot().getIntProperty(TAB_INDEX, 2)) < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(selectedIndex);
        }
        StartupFrame.setAppIcon(this.mainFrame.getFrame());
        this.mainFrame.showFrame(this.tabbedPane);
    }

    private void windowOpenedHandler() {
        this.setTitle();
        ConnectionStatus.INSTANCE.addListener(new ConnectionStatus.Listener(){

            @Override
            public void onConnectionStatus(boolean isConnected) {
                Launcher.this.setTitle();
                UiUtils.trueRepaint(Launcher.this.tabbedPane);
                if (ConnectionStatus.INSTANCE.getValue() == ConnectionStatus.Value.CONNECTED) {
                    long unixTime = System.currentTimeMillis() / 1000L;
                    long withOffset = unixTime + (long)(TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000);
                    CommandQueue.getInstance().write("set date " + withOffset, 500, InvocationConfirmationListener.VOID, false);
                }
            }
        });
        LinkManager.open(new LinkManager.LinkStateListener(){

            @Override
            public void onConnectionFailed() {
            }

            @Override
            public void onConnectionEstablished() {
                Launcher.this.tableEditor.showContent();
                Launcher.this.settingsTab.showContent();
                Launcher.this.logsManager.showContent();
                Launcher.this.fuelTunePane.showContent();
                BinaryProtocolServer.start();
            }
        });
        LinkManager.engineState.registerStringValueAction("rusEfiVersion", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String firmwareVersion) {
                Launcher.firmwareVersion.set(firmwareVersion);
                SensorLogger.init();
                Launcher.this.setTitle();
                VersionChecker.getInstance().onFirmwareVersion(firmwareVersion);
            }
        });
    }

    private void setTitle() {
        String disconnected = ConnectionStatus.INSTANCE.isConnected() ? "" : "DISCONNECTED ";
        this.mainFrame.getFrame().setTitle(disconnected + "Console " + 20170108 + "; firmware=" + firmwareVersion.get() + "@" + this.port);
    }

    private void windowClosedHandler() {
        SimulatorHelper.onWindowClosed();
        Node root = PersistentConfiguration.getConfig().getRoot();
        root.setProperty("version", 20170108);
        root.setProperty(TAB_INDEX, this.tabbedPane.getSelectedIndex());
        GaugesPanel.DetachedRepository.INSTANCE.saveConfig();
        PersistentConfiguration.getConfig().save();
        BinaryProtocol bp = BinaryProtocol.instance;
        if (bp != null && !bp.isClosed) {
            bp.close();
        }
        System.exit(0);
    }

    public static void main(final String[] args) throws Exception {
        FileLog.MAIN.start();
        PersistentConfiguration.getConfig().load();
        FileLog.suspendLogging = PersistentConfiguration.getConfig().getRoot().getBoolProperty("DISABLE_LOGS");
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        VersionChecker.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.awtCode(args);
            }
        });
    }

    private static void awtCode(String[] args) {
        int result;
        if (JustOneInstance.isAlreadyRunning() && (result = JOptionPane.showConfirmDialog(null, "Looks like another instance is already running. Do you really want to start another instance?", "rusEfi", 0)) == 1) {
            System.exit(-1);
        }
        wrongVersionListener = new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                if (value != 2.0161225E7) {
                    String message = "This copy of rusEfi console is not compatible with this version of firmware\r\nConsole compatible with 20161225 while firmware compatible with " + (int)value;
                    JOptionPane.showMessageDialog(Launcher.getFrame(), message);
                    assert (wrongVersionListener != null);
                    SensorCentral.getInstance().removeListener(Sensor.FIRMWARE_VERSION, wrongVersionListener);
                }
            }
        };
        SensorCentral.getInstance().addListener(Sensor.FIRMWARE_VERSION, wrongVersionListener);
        JustOneInstance.onStart();
        try {
            boolean isBaudRateDefined;
            boolean isPortDefined = args.length > 0;
            boolean bl = isBaudRateDefined = args.length > 1;
            if (isBaudRateDefined) {
                PortHolder.BAUD_RATE = Integer.parseInt(args[1]);
            }
            if (isPortDefined) {
                new Launcher(args[0]);
            } else {
                for (String p : SerialPortList.getPortNames()) {
                    MessagesCentral.getInstance().postMessage(Launcher.class, "Available port: " + p);
                }
                new StartupFrame().chooseSerialPort();
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static Frame getFrame() {
        return staticFrame;
    }

    static {
        firmwareVersion = new AtomicReference<String>("N/A");
    }
}

