/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AutoTest;
import com.rusefi.FileLog;
import com.rusefi.IoUtil;
import com.rusefi.TestingUtils;

public class RealHwTest {
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        String port = RealHwTest.startRealHardwareTest(args);
        if (port == null) {
            return;
        }
        boolean failed = false;
        try {
            RealHwTest.runRealHardwareTest(port);
        }
        catch (Throwable e) {
            e.printStackTrace();
            failed = true;
        }
        if (failed) {
            System.exit(-1);
        }
        FileLog.MAIN.logLine("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        FileLog.MAIN.logLine("++++++++++++++++++++++++++++++++++++  Real Hardware Test Passed +++++++++++++++");
        FileLog.MAIN.logLine("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        long time = (System.currentTimeMillis() - start) / 1000L;
        FileLog.MAIN.logLine("Done in " + time + "secs");
        System.exit(0);
    }

    static String startRealHardwareTest(String[] args) {
        String port;
        TestingUtils.isRealHardware = true;
        FileLog.MAIN.start();
        if (args.length == 1 || args.length == 2) {
            port = args[0];
        } else if (args.length == 0) {
            port = IoUtil.getDefaultPort();
        } else {
            System.out.println("Only one optional argument expected: port number");
            port = null;
        }
        return port;
    }

    private static void runRealHardwareTest(String port) {
        IoUtil.realHardwareConnect(port);
        AutoTest.mainTestBody();
    }
}

