/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.SensorSnifferCentral;
import com.rusefi.config.Fields;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.RpmModel;
import com.rusefi.ui.config.ConfigField;
import com.rusefi.ui.config.EnumConfigField;
import com.rusefi.ui.storage.Node;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SensorSnifferPane {
    private static final String HELP_URL = "http://rusefi.com/wiki/index.php?title=Manual:DevConsole#Analog_Chart";
    private final TreeMap<Double, Double> values = new TreeMap();
    private final SensorSnifferCanvas canvas = new SensorSnifferCanvas();
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private final JPanel content = new JPanel(new BorderLayout());
    private boolean paused = false;

    public SensorSnifferPane(Node config) {
        SensorSnifferCentral.addListener(new SensorSnifferCentral.AnalogChartListener(){

            @Override
            public void onAnalogChart(final String message) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SensorSnifferPane.this.unpackValues(SensorSnifferPane.this.values, message);
                        if (!SensorSnifferPane.this.paused) {
                            SensorSnifferPane.this.processValues();
                            UiUtils.trueRepaint(SensorSnifferPane.this.canvas);
                        }
                    }
                });
            }
        });
        final JPanel upperPanel = new JPanel(new FlowLayout(0, 5, 0));
        final JButton pauseButton = UiUtils.createPauseButton();
        JButton clearButton = UiUtils.createClearButton();
        clearButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorSnifferPane.this.clear();
                UiUtils.trueRepaint(SensorSnifferPane.this.canvas);
                SensorSnifferPane.this.setPaused(pauseButton, false);
            }
        });
        upperPanel.add(clearButton);
        JButton saveImageButton = UiUtils.createSaveImageButton();
        upperPanel.add(saveImageButton);
        saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rpm = RpmModel.getInstance().getValue();
                String fileName = FileLog.getDate() + "_rpm_" + rpm + "_sensor.png";
                UiUtils.saveImageWithPrompt(fileName, upperPanel, SensorSnifferPane.this.canvas);
            }
        });
        upperPanel.add(pauseButton);
        upperPanel.add(new RpmLabel(2).getContent());
        upperPanel.add(AnyCommand.createField(config, true, false).getContent());
        upperPanel.add(new URLLabel("Click here for online help", HELP_URL));
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorSnifferPane.this.setPaused(pauseButton, !SensorSnifferPane.this.paused);
            }
        });
        this.content.add((Component)upperPanel, "North");
        this.content.add((Component)this.canvas, "Center");
        JPanel lowerPanel = new JPanel(new FlowLayout(1, 5, 0));
        lowerPanel.setBorder(BorderFactory.createLineBorder(Color.cyan));
        this.content.add((Component)lowerPanel, "South");
        lowerPanel.add(new EnumConfigField(Fields.SENSORCHARTMODE, "Mode").getContent());
        lowerPanel.add(new ConfigField(Fields.SENSORCHARTFREQUENCY, "Every XXX engine cycles").getContent());
    }

    private void setPaused(JButton pauseButton, boolean isPaused) {
        this.paused = isPaused;
        UiUtils.setPauseButtonText(pauseButton, this.paused);
    }

    private void clear() {
        this.maxY = 0.0;
        this.minY = 0.0;
        this.maxX = 0.0;
        this.minX = 0.0;
        this.values.clear();
    }

    private void processValues() {
        ArrayList<Double> keys = new ArrayList<Double>(this.values.keySet());
        this.minX = (Double)keys.get(0);
        this.maxX = (Double)keys.get(keys.size() - 1);
        FileLog.MAIN.logLine("Analog chart from " + this.minX + " to " + this.maxX);
        TreeSet<Double> sortedValues = new TreeSet<Double>();
        sortedValues.addAll(this.values.values());
        ArrayList values = new ArrayList(sortedValues);
        this.minY = (Double)values.get(0);
        this.maxY = (Double)values.get(values.size() - 1);
    }

    public JComponent getPanel() {
        return this.content;
    }

    private void unpackValues(TreeMap<Double, Double> values, String chart) {
        values.clear();
        String[] tokens = chart.split("\\|");
        int i = 0;
        while (i < tokens.length - 1) {
            String key = tokens[i++];
            String value = tokens[i++];
            values.put(Double.parseDouble(key), Double.parseDouble(value));
        }
    }

    private class SensorSnifferCanvas
    extends JComponent {
        private SensorSnifferCanvas() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            g.drawString("X range from " + SensorSnifferPane.this.minX + " to " + SensorSnifferPane.this.maxX, 4, 20);
            g.drawString("Y range from " + SensorSnifferPane.this.minY + " to " + SensorSnifferPane.this.maxY, 4, 40);
            int prevX = 0;
            int prevY = size.height;
            double bX = (double)size.width / (SensorSnifferPane.this.maxX - SensorSnifferPane.this.minX);
            double bY = (double)size.height / (SensorSnifferPane.this.maxY - SensorSnifferPane.this.minY);
            for (Map.Entry e : SensorSnifferPane.this.values.entrySet()) {
                int x = (int)(((Double)e.getKey() - SensorSnifferPane.this.minX) * bX);
                int y = size.height - (int)(((Double)e.getValue() - SensorSnifferPane.this.minY) * bY);
                g.drawLine(prevX, prevY, x, y);
                prevX = x;
                prevY = y;
            }
        }
    }
}

