/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.Launcher;
import com.rusefi.SimulatorHelper;
import com.rusefi.io.serial.PortHolder;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.maintenance.EraseChip;
import com.rusefi.maintenance.FirmwareFlasher;
import com.rusefi.maintenance.ProcessStatusWindow;
import com.rusefi.ui.storage.PersistentConfiguration;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import jssc.SerialPortList;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class StartupFrame {
    private static final String APPICON = "appicon.png";
    private static final String LOGO = "logo.gif";
    private static final String LINK_TEXT = "rusEfi (c) 2012-2017";
    private static final String URI = "http://rusefi.com/?java_console";
    private static final String VCP_DRIVER_TEXT = "vcp driver";
    private static final String VCP_DRIVER_URI = "http://www.st.com/st-web-ui/static/active/en/st_prod_software_internet/resource/technical/software/driver/stsw-stm32102.zip";
    private final JFrame frame;
    private final Timer scanPortsTimes = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StartupFrame.this.findAndApplyPorts();
        }
    });
    private final JPanel connectPanel = new JPanel(new FlowLayout());
    private final JComboBox<String> comboPorts = new JComboBox();
    @NotNull
    private List<String> currentlyDisplayedPorts = new ArrayList<String>();
    private boolean isFirstTimeApplyingPorts = true;
    private JPanel leftPanel;
    private boolean isProceeding;
    private JLabel noPortsMessage = new JLabel("No ports found!");

    public StartupFrame() {
        this.frame = new JFrame("rusEfi console v20170108");
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                if (!StartupFrame.this.isProceeding) {
                    PersistentConfiguration.getConfig().save();
                    System.exit(0);
                }
            }
        });
        StartupFrame.setAppIcon(this.frame);
        this.scanPortsTimes.start();
    }

    public static void setAppIcon(JFrame frame) {
        ImageIcon icon = UiUtils.loadIcon(APPICON);
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
    }

    public void chooseSerialPort() {
        this.leftPanel = new JPanel(new VerticalFlowLayout());
        this.leftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(Color.darkGray)));
        this.connectPanel.add(this.comboPorts);
        final JComboBox<String> comboSpeeds = StartupFrame.createSpeedCombo();
        this.connectPanel.add(comboSpeeds);
        JButton connect = new JButton("Connect");
        this.connectPanel.add(connect);
        connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartupFrame.this.disposeFrameAndProceed();
                PortHolder.BAUD_RATE = Integer.parseInt((String)comboSpeeds.getSelectedItem());
                new Launcher(StartupFrame.this.comboPorts.getSelectedItem().toString());
            }
        });
        this.leftPanel.add(this.connectPanel);
        this.leftPanel.add(this.noPortsMessage);
        this.installMessage(this.noPortsMessage, "Check you cables. Check your drivers. Do you want to start simulator maybe?");
        this.leftPanel.add(new URLLabel(VCP_DRIVER_TEXT, VCP_DRIVER_URI));
        this.leftPanel.add(new HorizontalLine());
        this.findAndApplyPorts();
        JButton buttonLogViewer = new JButton();
        buttonLogViewer.setText("Start log viewer");
        buttonLogViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartupFrame.this.disposeFrameAndProceed();
                new Launcher("log viewer");
            }
        });
        this.leftPanel.add(buttonLogViewer);
        this.leftPanel.add(new HorizontalLine());
        this.leftPanel.add(SimulatorHelper.createSimulatorComponent(this));
        if (ProcessStatusWindow.isWindows()) {
            this.leftPanel.add(new HorizontalLine());
            this.leftPanel.add(new FirmwareFlasher("rusefi_debug.bin", "Program Firmware/Debug").getButton());
            this.leftPanel.add(new HorizontalLine());
            this.leftPanel.add(new FirmwareFlasher("rusefi_release.bin", "Program Firmware/Release").getButton());
            this.leftPanel.add(new HorizontalLine());
            this.leftPanel.add(new EraseChip().getButton());
        }
        JPanel rightPanel = new JPanel(new VerticalFlowLayout());
        ImageIcon logoIcon = UiUtils.loadIcon(LOGO);
        if (logoIcon != null) {
            JLabel logo = new JLabel(logoIcon);
            logo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            URLLabel.addUrlAction(logo, URLLabel.createUri(URI));
            logo.setCursor(new Cursor(12));
            rightPanel.add(logo);
        }
        rightPanel.add(new URLLabel(LINK_TEXT, URI));
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.leftPanel, "West");
        content.add((Component)rightPanel, "East");
        this.frame.add(content);
        this.frame.pack();
        this.frame.setVisible(true);
        UiUtils.centerWindow(this.frame);
    }

    private void installMessage(JComponent component, String s) {
        component.setToolTipText(s);
    }

    private void findAndApplyPorts() {
        List<String> ports = this.findAllAvailablePorts();
        if (!this.currentlyDisplayedPorts.equals(ports) || this.isFirstTimeApplyingPorts) {
            FileLog.MAIN.logLine("Available ports " + ports);
            this.isFirstTimeApplyingPorts = false;
            this.connectPanel.setVisible(!ports.isEmpty());
            this.noPortsMessage.setVisible(ports.isEmpty());
            this.addPortSelection(ports);
            this.currentlyDisplayedPorts = ports;
            UiUtils.trueLayout(this.connectPanel);
            this.frame.pack();
        }
    }

    @NotNull
    private List<String> findAllAvailablePorts() {
        ArrayList<String> ports = new ArrayList<String>();
        ports.addAll(Arrays.asList(SerialPortList.getPortNames()));
        ports.addAll(TcpConnector.getAvailablePorts());
        return ports;
    }

    public void disposeFrameAndProceed() {
        this.isProceeding = true;
        this.frame.dispose();
        this.scanPortsTimes.stop();
    }

    private void addPortSelection(List<String> ports) {
        this.comboPorts.removeAllItems();
        for (String port : ports) {
            this.comboPorts.addItem(port);
        }
        String defaultPort = PersistentConfiguration.getConfig().getRoot().getProperty("port");
        this.comboPorts.setSelectedItem(defaultPort);
    }

    private static JComboBox<String> createSpeedCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        String defaultSpeed = PersistentConfiguration.getConfig().getRoot().getProperty("speed", "115200");
        for (int speed : new int[]{9600, 14400, 19200, 38400, 57600, 115200, 460800, 921600}) {
            combo.addItem(Integer.toString(speed));
        }
        combo.setSelectedItem(defaultSpeed);
        return combo;
    }
}

