/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.EcuStimulator;
import com.rusefi.ValueRangeControl;
import com.rusefi.ui.util.UiUtils;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class StimulationInputs {
    static final int DEFAULT_RPM_MIN = 800;
    static final int DEFAULT_RPM_MAX = 7000;
    private final JPanel content = new JPanel(new GridLayout(7, 1));
    private final JSpinner elResistance2 = new JSpinner(new SpinnerNumberModel(10000, 0, 100000, 1));
    private final ValueRangeControl elRange = new ValueRangeControl("engine load", 1.2, 0.213333, 4.4);
    private final ValueRangeControl rpmRange = new ValueRangeControl("RPM", 800.0, 413.333374, 7000.0);
    private final ValueRangeControl cltRange = new ValueRangeControl("CLR r", 100.0, 100.0, 100.0);
    private final ValueRangeControl iatRange = new ValueRangeControl("IAT r", 100.0, 100.0, 9900.0);
    private final ValueRangeControl tpsRange = new ValueRangeControl("TPS", 1.0, 0.1, 4.5);

    public StimulationInputs(EcuStimulator ecuStimulator) {
        JPanel channelPanel = new JPanel(new FlowLayout());
        channelPanel.add(new JLabel("Input channel"));
        this.content.add(channelPanel);
        this.content.add(this.rpmRange.getContent());
        this.content.add(this.elRange.getContent());
        this.content.add(this.cltRange.getContent());
        this.content.add(this.iatRange.getContent());
        this.content.add(this.tpsRange.getContent());
        this.content.add(new JLabel("EL resistance"));
        this.content.add(UiUtils.wrap(this.elResistance2));
        JButton button = ecuStimulator.createButton();
    }

    public double getEngineLoadMin() {
        return this.elRange.getFrom();
    }

    public double getEngineLoadMax() {
        return this.elRange.getTo();
    }

    public double getRpmFrom() {
        return (int)this.rpmRange.getFrom();
    }

    public double getRpmTo() {
        return (int)this.rpmRange.getTo();
    }

    public double getRpmStep() {
        return this.rpmRange.getStep();
    }

    public int getCltFrom() {
        return (int)this.cltRange.getFrom();
    }

    public int getCltTo() {
        return (int)this.cltRange.getTo();
    }

    public JPanel getContent() {
        return this.content;
    }

    public double getEngineLoadR2Resistance() {
        return ((Integer)this.elResistance2.getValue()).intValue();
    }

    public double getEngineLoadStep() {
        return this.elRange.getStep();
    }
}

