/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class TS2C {
    private final int size;
    private int rpmCount;
    private int loadCount;
    private float[] loadBins;
    private float[] rpmBins;
    private float[][] table;

    public static void main(String[] args) throws IOException {
        new TS2C(args);
    }

    private TS2C(String[] args) throws IOException {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Four parameters expected: ");
            System.out.println("  INPUT_MSQ_FILE NAME LOAD_SECTION_NAME RPM_SECTION_NAME TABLE_NAME");
            System.out.println("for example");
            System.out.println("  currenttune.msq veLoadBins veRpmBins veTable");
            System.exit(-1);
        }
        String fileName = args[0];
        String loadSectionName = args[1];
        String rpmSectionName = args[2];
        String tableName = args[3];
        BufferedReader r = TS2C.readAndScroll(fileName, loadSectionName);
        this.loadCount = this.size = Integer.parseInt(args.length > 4 ? args[4] : "16");
        this.loadBins = new float[this.loadCount];
        this.readAxle(this.loadBins, r);
        r = TS2C.readAndScroll(fileName, rpmSectionName);
        this.rpmCount = this.size;
        this.rpmBins = new float[this.rpmCount];
        this.readAxle(this.rpmBins, r);
        this.table = new float[this.size][];
        for (int i = 0; i < this.size; ++i) {
            this.table[i] = new float[this.size];
        }
        r = TS2C.readAndScroll(fileName, tableName);
        this.readTable(this.table, r);
        BufferedWriter w = new BufferedWriter(new FileWriter("output.c"));
        this.writeTable(w, new ValueSource(){

            @Override
            public float getValue(int loadIndex, int rpmIndex) {
                return TS2C.this.table[loadIndex][rpmIndex];
            }
        }, "TS2C");
    }

    private void writeTable(BufferedWriter w, ValueSource valueSource, String toolName) throws IOException {
        w.write("/* Generated by " + toolName + " on " + new Date() + "*/\r\n");
        for (int loadIndex = 0; loadIndex < this.loadCount; ++loadIndex) {
            this.writeLine(valueSource, w, loadIndex);
        }
        w.close();
    }

    private static BufferedReader readAndScroll(String fileName, String sectionName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        System.out.println("Reading from " + fileName + ", scrolling to " + sectionName);
        while ((line = reader.readLine()) != null) {
            if (!line.contains(sectionName)) continue;
            System.out.println("Found " + line);
            break;
        }
        return reader;
    }

    private void writeLine(ValueSource valueSource, BufferedWriter w, int loadIndex) throws IOException {
        StringBuilder sb = new StringBuilder("{");
        sb.append("/* " + loadIndex + " " + String.format("%3.3f", Float.valueOf(this.loadBins[loadIndex])) + "\t*/");
        for (int rpmIndex = 0; rpmIndex < this.rpmCount; ++rpmIndex) {
            sb.append("/* " + rpmIndex + " " + this.rpmBins[rpmIndex] + "*/" + String.format("%3.3f", Float.valueOf(valueSource.getValue(loadIndex, rpmIndex))) + ",\t");
        }
        sb.append("},\r\n");
        w.write(sb.toString());
    }

    private void readTable(float[][] table, BufferedReader r) throws IOException {
        int index = 0;
        while (index < this.size) {
            String line = r.readLine();
            if (line == null) {
                throw new IOException("End of file?");
            }
            if ((line = line.trim()).isEmpty()) continue;
            String[] values = line.split(" ");
            if (values.length != this.size) {
                throw new IllegalStateException("Unexpected line: " + line);
            }
            for (int i = 0; i < this.size; ++i) {
                table[index][i] = Float.parseFloat(values[i]);
            }
            System.out.println("Got line " + index + ": " + Arrays.toString(table[index]));
            ++index;
        }
    }

    private void readAxle(float[] bins, BufferedReader r) throws IOException {
        int index = 0;
        while (index < this.size) {
            String line = r.readLine();
            if (line == null) {
                throw new IOException("End of file?");
            }
            if ((line = line.trim()).isEmpty()) continue;
            bins[index++] = Float.parseFloat(line);
        }
        System.out.println("Got bins " + Arrays.toString(bins));
    }

    static interface ValueSource {
        public float getValue(int var1, int var2);
    }
}

