/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AutoTest;
import com.rusefi.FileLog;
import com.rusefi.IoUtil;
import com.rusefi.core.EngineState;
import com.rusefi.io.LinkManager;
import com.rusefi.waves.EngineChart;
import com.rusefi.waves.EngineChartParser;
import com.rusefi.waves.EngineReport;
import com.rusefi.waves.RevolutionLog;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class TestingUtils {
    static boolean isRealHardware;

    static void assertTrue(String msg, boolean b) {
        if (!b) {
            TestingUtils.fail("Not true: " + msg);
        }
    }

    static void assertCloseEnough(String msg, double current, double ratio, double ... expectations) {
        for (double expected : expectations) {
            if (!EngineReport.isCloseEnough(TestingUtils.fixAngle(expected), current, ratio)) continue;
            return;
        }
        if (expectations.length == 1) {
            TestingUtils.fail(msg + ": Got " + current + " while expecting " + Arrays.toString(expectations) + " ratio=" + Math.abs(1.0 - expectations[0] / current) + TestingUtils.printRange(current, ratio));
        }
        TestingUtils.fail(msg + ": Got " + current + " while expecting " + Arrays.toString(expectations) + TestingUtils.printRange(current, ratio));
    }

    private static String printRange(double current, double ratio) {
        return " expected range from " + current / (1.0 + ratio) + " to " + current / (1.0 - ratio) + " with ratio " + ratio;
    }

    private static double fixAngle(double angle) {
        while (angle >= 720.0) {
            angle -= 720.0;
        }
        return angle;
    }

    private static void fail(String message) {
        FileLog.MAIN.logLine("FAILURE: " + message);
        IllegalStateException exception = new IllegalStateException(message);
        FileLog.MAIN.log(exception);
        throw exception;
    }

    static void assertTrue(boolean b) {
        if (!b) {
            TestingUtils.fail("Not true");
        }
    }

    static void assertWave(EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWave("", chart, key, width, expectedAngles);
    }

    static void assertWave(String msg, EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWave(true, msg, chart, key, width, 0.05, 0.05, expectedAngles);
    }

    static void assertWaveFall(EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWaveFall("", chart, key, width, expectedAngles);
    }

    static void assertWaveFall(String msg, EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWave(false, msg, chart, key, width, 0.05, 0.05, expectedAngles);
    }

    static void assertWave(boolean rise, String msg, EngineChart chart, String key, double expectedWidth, double angleRatio, double widthRatio, double ... expectedAngles) {
        if (isRealHardware) {
            return;
        }
        RevolutionLog revolutionLog = chart.getRevolutionsLog();
        if (revolutionLog.getSize() < 2) {
            throw new IllegalStateException(msg + " Not many revolutions in " + chart);
        }
        StringBuilder events = chart.get(key);
        TestingUtils.assertTrue(msg + " Events not null for " + key, events != null);
        List<EngineReport.UpDown> wr = EngineReport.parse(events.toString());
        TestingUtils.assertTrue(msg + " waves for " + key, !wr.isEmpty());
        for (EngineReport.UpDown ud : wr) {
            int eventTime = rise ? ud.upTime : ud.downTime;
            double angleByTime = revolutionLog.getCrankAngleByTime(eventTime);
            TestingUtils.assertCloseEnough(msg + " angle for " + key + "@" + eventTime, TestingUtils.fixAngle(angleByTime), angleRatio, expectedAngles);
            double actualWidth = ud.getDutyCycle(revolutionLog);
            if (!EngineReport.isCloseEnough(TestingUtils.fixAngle(actualWidth), expectedWidth, widthRatio)) {
                System.out.println("f " + revolutionLog.getCrankAngleByTime(ud.downTime));
                System.out.println("t " + revolutionLog.getCrankAngleByTime(ud.upTime));
            }
            TestingUtils.assertCloseEnough(msg + " width for " + key, actualWidth, widthRatio, expectedWidth);
        }
    }

    static void assertNull(String msg, Object value) {
        TestingUtils.assertTrue(msg, value == null);
    }

    static EngineChart nextChart() {
        TestingUtils.getNextWaveChart();
        TestingUtils.getNextWaveChart();
        return EngineChartParser.unpackToMap(TestingUtils.getNextWaveChart());
    }

    static String getNextWaveChart() {
        IoUtil.sendCommand("reset_engine_chart");
        String result = TestingUtils.getEngineChart();
        FileLog.MAIN.logLine("current chart: " + result);
        return result;
    }

    private static String getEngineChart() {
        final CountDownLatch engineChartLatch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        FileLog.MAIN.logLine("waiting for next chart");
        LinkManager.engineState.replaceStringValueAction("wave_chart", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                engineChartLatch.countDown();
                result.set(value);
            }
        });
        int timeout = 60;
        long waitStartTime = System.currentTimeMillis();
        IoUtil.wait(engineChartLatch, timeout);
        FileLog.MAIN.logLine("got next chart in " + (System.currentTimeMillis() - waitStartTime) + "ms for engine_type " + AutoTest.currentEngineType);
        LinkManager.engineState.replaceStringValueAction("wave_chart", EngineState.ValueCallback.VOID);
        if (result.get() == null) {
            throw new IllegalStateException("Chart timeout: " + timeout);
        }
        return (String)result.get();
    }
}

