/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.ConfigurationImage;
import com.rusefi.Logger;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.ConfigurationImageFile;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.PortHolder;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.StatusWindow;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jssc.SerialPort;
import jssc.SerialPortException;

public class UploadChanges {
    private static final StatusWindow wnd = new StatusWindow();
    public static final Logger logger;

    public static void main(String[] args) throws SerialPortException, InvocationTargetException, InterruptedException {
        if (args.length != 1) {
            System.out.println("Exactly one parameter expected");
            return;
        }
        final String port = args[0];
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UploadChanges.showUi(port);
                }
                catch (IOException | InterruptedException | SerialPortException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static void showUi(String port) throws SerialPortException, IOException, InterruptedException {
        SerialPort serialPort = new SerialPort(port);
        boolean opened = serialPort.openPort();
        if (!opened) {
            logger.error("failed to open " + port);
        }
        PortHolder.setupPort(serialPort, 38400);
        logger.info("Looks good");
        ConfigurationImage ci1 = ConfigurationImageFile.readFromFile("rus_saved.bin");
        ConfigurationImage ci2 = ConfigurationImageFile.readFromFile("rusefi_configuration.bin");
        BinaryProtocol bp = new BinaryProtocol(logger, serialPort);
        bp.setController(ci1);
        UploadChanges.scheduleUpload(ci2, null);
    }

    public static void scheduleUpload(final ConfigurationImage newVersion, final Runnable afterUpload) {
        JFrame frame = wnd.getFrame();
        frame.setVisible(true);
        LinkManager.COMMUNICATION_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BinaryProtocol.instance.uploadChanges(newVersion, logger);
                    if (afterUpload != null) {
                        afterUpload.run();
                    }
                }
                catch (EOFException | InterruptedException | SerialPortException e) {
                    logger.error("Error: " + e);
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return "Runnable for burn";
            }
        });
    }

    private static Logger createUiLogger() {
        return new Logger(){

            @Override
            public void trace(String msg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }

            @Override
            public void info(final String msg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println(msg);
                        wnd.appendMsg(msg);
                    }
                });
            }

            @Override
            public void error(final String msg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println(msg);
                        wnd.appendMsg(msg);
                    }
                });
            }
        };
    }

    static {
        wnd.getFrame().setDefaultCloseOperation(1);
        wnd.getFrame().setTitle("rusEfi bin upload");
        wnd.getFrameHelper().initFrame(wnd.getContent(), false);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add(RecentCommands.createButton(new AtomicBoolean(), "writeconfig"));
        wnd.getContent().add((Component)bottomPanel, "South");
        logger = UploadChanges.createUiLogger();
    }
}

