/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune;

import com.rusefi.autotune.FuelAutoLogic;
import com.rusefi.autotune.MathUtil;
import com.rusefi.autotune.Result;
import com.rusefi.autotune.stDataOnline;
import java.util.Collection;

public enum FuelAutoTune implements FuelAutoLogic
{
    INSTANCE;

    public static final int SIZE = 16;

    private static boolean isLogEnabled() {
        return true;
    }

    @Override
    public Result process(boolean smooth, Collection<stDataOnline> dataECU, double STEP, double targetAFR, float[][] kgbcINIT) {
        float[][] kgbcSQ = new float[16][16];
        double kgbcSQsum = 0.0;
        double minSQtotal = 1.0E15;
        double kgbcSQsumLastTotal = 1.0E16;
        double ksq = 1000.0;
        double ke = 100.0;
        double kg = 100.0;
        int[][] bkGBC = new int[16][16];
        for (stDataOnline data : dataECU) {
            int[] nArray = bkGBC[data.PRESS_RT_32()];
            int n = data.RPM_RT_32();
            nArray[n] = nArray[n] + 1;
        }
        float[][] result = MathUtil.deepCopy(kgbcINIT);
        double[][] ktgbcRES = new double[16][16];
        double[][] ktgbcINIT = new double[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                ktgbcINIT[i][j] = 1.0;
                ktgbcRES[i][j] = 1.0;
            }
        }
        int gMinRT = 20;
        int minK = 0;
        while (true) {
            for (int r = 0; r < 16; ++r) {
                for (int c = 0; c < 16; ++c) {
                    if (bkGBC[r][c] < gMinRT) continue;
                    double minSQ = 1.0E16;
                    kgbcSQsum = 1.0E16;
                    double step = STEP;
                    double mink = 0.0;
                    do {
                        for (int i = 0; i < 16; ++i) {
                            for (int j = 0; j < 16; ++j) {
                                kgbcSQ[i][j] = 0.0f;
                            }
                        }
                        double kgbcSQsumLast = kgbcSQsum;
                        FuelAutoTune.countDeviation(dataECU, kgbcSQ, result, kgbcINIT, targetAFR);
                        kgbcSQsum = MathUtil.sumArray(kgbcSQ);
                        if (smooth) {
                            kgbcSQsum = FuelAutoTune.smooth(kgbcSQsum, ksq, ke, kg, result);
                        }
                        if (kgbcSQsum >= kgbcSQsumLast) {
                            step = -step;
                        }
                        float[] fArray = result[r];
                        int n = c;
                        fArray[n] = (float)((double)fArray[n] + step);
                        if (kgbcSQsum < minSQ) {
                            minSQ = kgbcSQsum;
                        }
                        if (!(Math.abs(minSQ - kgbcSQsumLast) < 1.0E-10)) continue;
                        mink += 1.0;
                    } while (!(mink > 4.0));
                    FuelAutoTune.log("break " + c + "/" + r);
                }
            }
            if (kgbcSQsum < minSQtotal) {
                minSQtotal = kgbcSQsum;
            }
            if (Math.abs(minSQtotal - kgbcSQsumLastTotal) < 1.0E-10) {
                ++minK;
            }
            if (minK > 4) {
                FuelAutoTune.log("return " + minK);
                return new Result(result);
            }
            kgbcSQsumLastTotal = kgbcSQsum;
        }
    }

    private static void countDeviation(Collection<stDataOnline> dataECU, float[][] kgbcSQ, float[][] kgbcRES, float[][] kgbcINIT, double targetAFR) {
        for (stDataOnline dataPoint : dataECU) {
            double corrInit = 1.0;
            double corrRes = 1.0;
            double tpsCorrInit = 1.0;
            double tpsCorrRes = 1.0;
            double ALF = targetAFR / 14.7;
            double tmp = dataPoint.AFR / 14.7 - ALF * ((double)kgbcRES[dataPoint.PRESS_RT_32()][dataPoint.RPM_RT_32()] * tpsCorrRes * corrRes) / ((double)kgbcINIT[dataPoint.PRESS_RT_32()][dataPoint.RPM_RT_32()] * tpsCorrInit * corrInit);
            float[] fArray = kgbcSQ[dataPoint.PRESS_RT_32()];
            int n = dataPoint.RPM_RT_32();
            fArray[n] = (float)((double)fArray[n] + Math.abs(tmp));
        }
    }

    private static double smooth(double kgbcSQsum, double ksq, double ke, double kg, float[][] kgbcRES) {
        double tmp;
        int j;
        int i;
        kgbcSQsum = ksq * kgbcSQsum;
        double e = 0.0;
        for (i = 0; i < 15; ++i) {
            for (j = 0; j < 16; ++j) {
                tmp = kgbcRES[i][j] - kgbcRES[i + 1][j];
                e += tmp * tmp;
                tmp = kgbcRES[j][i] - kgbcRES[j][i + 1];
                e += tmp * tmp;
            }
        }
        double g = 0.0;
        for (i = 0; i < 14; ++i) {
            for (j = 0; j < 16; ++j) {
                tmp = kgbcRES[i][j] - 2.0f * kgbcRES[i + 1][j] + kgbcRES[i + 2][j];
                g += tmp * tmp;
                tmp = kgbcRES[j][i] - 2.0f * kgbcRES[j][i + 1] + kgbcRES[j][i + 2];
                g += tmp * tmp;
            }
        }
        return kgbcSQsum += ke * e + kg * g;
    }

    private static void log(String s) {
        System.out.println(s);
    }
}

