/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune;

public class stDataOnline {
    public final double AFR;
    private final int rpm;
    private final double engineLoad;
    int rpmIndex;
    int engineLoadIndex;

    public stDataOnline(double AFR, int rpmIndex, int engineLoadIndex, int rpm, double engineLoad) {
        this.rpm = rpm;
        this.engineLoad = engineLoad;
        if (rpmIndex < 0 || rpmIndex >= 16) {
            throw new IllegalStateException("rpmIndex " + rpmIndex);
        }
        if (engineLoadIndex < 0 || engineLoadIndex >= 16) {
            throw new IllegalStateException("engineLoadIndex " + engineLoadIndex);
        }
        this.AFR = AFR;
        this.rpmIndex = rpmIndex;
        this.engineLoadIndex = engineLoadIndex;
    }

    public static stDataOnline valueOf(double AFR, int rpm, double engineLoad) {
        int rpmIndex = (int)((double)rpm / 7000.0 * 16.0);
        if (rpmIndex < 0 || rpmIndex >= 16) {
            return null;
        }
        int engineLoadIndex = (int)(engineLoad / 120.0 * 16.0);
        return new stDataOnline(AFR, rpmIndex, engineLoadIndex, rpm, engineLoad);
    }

    int getRpmIndex() {
        return this.rpmIndex;
    }

    public int getEngineLoadIndex() {
        return this.engineLoadIndex;
    }

    public int PRESS_RT_32() {
        return this.getEngineLoadIndex();
    }

    public int RPM_RT_32() {
        return this.getRpmIndex();
    }

    public int getRpm() {
        return this.rpm;
    }

    public double getEngineLoad() {
        return this.engineLoad;
    }
}

