/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune.test;

import com.rusefi.autotune.FuelAutoTune2;
import com.rusefi.autotune.Result;
import com.rusefi.autotune.stDataOnline;
import com.rusefi.autotune.test.FuelAutoTuneTest;
import java.util.ArrayList;
import org.junit.Test;

public class FuelAutoTune2Test {
    @Test
    public void testAutoTune() {
        ArrayList<stDataOnline> dataPoints = new ArrayList<stDataOnline>();
        dataPoints.add(stDataOnline.valueOf(13.0, 1200, 80.0));
        System.out.println("Running with one datapoint already at target AFR");
        Result r = FuelAutoTune2.INSTANCE.process(false, dataPoints, 0.1, 13.0, FuelAutoTuneTest.createVeTable());
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
        dataPoints.add(stDataOnline.valueOf(13.0, 1200, 80.0));
        dataPoints.add(stDataOnline.valueOf(14.0, 1300, 60.0));
        dataPoints.add(stDataOnline.valueOf(15.0, 1400, 70.0));
        dataPoints.add(stDataOnline.valueOf(16.0, 1500, 90.0));
        for (int i = 0; i < 2000; ++i) {
            dataPoints.add(stDataOnline.valueOf(16.0, 1500 + i, 90.0));
        }
        System.out.println("Running with more datapoints");
        r = FuelAutoTune2.INSTANCE.process(false, dataPoints, 0.01, 13.0, FuelAutoTuneTest.createVeTable());
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
        for (int i = 0; i < 2000; ++i) {
            dataPoints.add(stDataOnline.valueOf(15.0, 1500 + i, 90.0));
        }
        System.out.println("Running with more datapoints");
        r = FuelAutoTune2.INSTANCE.process(false, dataPoints, 0.01, 13.0, FuelAutoTuneTest.createVeTable());
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
    }
}

