/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune.test;

import com.rusefi.autotune.FuelAutoTune;
import com.rusefi.autotune.Result;
import com.rusefi.autotune.stDataOnline;
import java.util.ArrayList;
import org.junit.Test;

public class FuelAutoTuneTest {
    @Test
    public void testAutoTune() {
        ArrayList<stDataOnline> dataPoints = new ArrayList<stDataOnline>();
        dataPoints.add(stDataOnline.valueOf(13.0, 1200, 80.0));
        Result r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.1, 13.0, FuelAutoTuneTest.createVeTable());
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
        dataPoints.add(stDataOnline.valueOf(13.0, 1200, 80.0));
        dataPoints.add(stDataOnline.valueOf(14.0, 1300, 60.0));
        dataPoints.add(stDataOnline.valueOf(15.0, 1400, 70.0));
        dataPoints.add(stDataOnline.valueOf(16.0, 1500, 90.0));
        for (int i = 0; i < 2000; ++i) {
            dataPoints.add(stDataOnline.valueOf(16.0, 1500 + i, 90.0));
        }
        r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.01, 13.0, FuelAutoTuneTest.createVeTable());
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
        for (int i = 0; i < 2000; ++i) {
            dataPoints.add(stDataOnline.valueOf(15.0, 1500 + i, 90.0));
        }
        r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.01, 13.0, FuelAutoTuneTest.createVeTable());
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
    }

    static void printNotDefault(float[][] array, double defaultValue) {
        for (int i = 0; i < array.length; ++i) {
            FuelAutoTuneTest.printNotDefault(array[i], i, defaultValue);
        }
    }

    private static void printNotDefault(float[] array, int index, double defaultValue) {
        for (int i = 0; i < array.length; ++i) {
            if ((double)array[i] == defaultValue) continue;
            System.out.println("Found value: x=" + index + " y=" + i + ": " + array[i]);
        }
    }

    static float[][] createVeTable() {
        float[][] veMap = new float[16][16];
        for (int engineLoadIndex = 0; engineLoadIndex < 16; ++engineLoadIndex) {
            for (int rpmIndex = 0; rpmIndex < 16; ++rpmIndex) {
                veMap[engineLoadIndex][rpmIndex] = 1.0f;
            }
        }
        return veMap;
    }
}

