/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.rusefi.ConfigurationImage;
import com.rusefi.ConfigurationImageDiff;
import com.rusefi.FileLog;
import com.rusefi.Logger;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.config.FieldType;
import com.rusefi.core.Pair;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.CommunicationLoggingHolder;
import com.rusefi.io.ConnectionStatus;
import com.rusefi.io.DataListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.SerialIoStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jssc.SerialPort;
import jssc.SerialPortException;

public class BinaryProtocol {
    public static final int OUTPUT_CHANNELS_SIZE = 276;
    private static final int BLOCKING_FACTOR = 400;
    private static final byte RESPONSE_OK = 0;
    private static final byte RESPONSE_BURN_OK = 4;
    private static final byte RESPONSE_COMMAND_OK = 7;
    private static final int SWITCH_TO_BINARY_RESPONSE = 32266;
    private static final String SWITCH_TO_BINARY_COMMAND = "~";
    public static final char COMMAND_OUTPUTS = 'O';
    public static final char COMMAND_HELLO = 'S';
    public static final char COMMAND_PROTOCOL = 'F';
    public static final char COMMAND_CRC_CHECK_COMMAND = 'k';
    public static final char COMMAND_PAGE = 'P';
    public static final char COMMAND_READ = 'R';
    public static final char COMMAND_CHUNK_WRITE = 'C';
    public static final char COMMAND_BURN = 'B';
    private final Logger logger;
    private final IoStream stream;
    private final IncomingDataBuffer incomingData;
    private boolean isBurnPending;
    private final Object ioLock = new Object();
    private final Object imageLock = new Object();
    private ConfigurationImage controller;
    @Deprecated
    public static BinaryProtocol instance;
    public boolean isClosed;
    public static byte[] currentOutputs;
    private static final char[] hexCode;

    public BinaryProtocol(Logger logger, IoStream stream) {
        this.logger = logger;
        this.stream = stream;
        instance = this;
        this.incomingData = new IncomingDataBuffer(logger);
        DataListener streamDataListener = new DataListener(){

            @Override
            public void onDataArrived(byte[] freshData) {
                BinaryProtocol.this.incomingData.addData(freshData);
            }
        };
        stream.setDataListener(streamDataListener);
    }

    public BinaryProtocol(Logger logger, SerialPort serialPort) {
        this(logger, new SerialIoStream(serialPort, logger));
    }

    private static void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void doSend(final String command, boolean fireEvent) throws InterruptedException {
        FileLog.MAIN.logLine("Sending [" + command + "]");
        if (fireEvent && LinkManager.LOG_LEVEL.isDebugEnabled()) {
            CommunicationLoggingHolder.communicationLoggingListener.onPortHolderMessage(BinaryProtocol.class, "Sending [" + command + "]");
        }
        Future<?> f = LinkManager.COMMUNICATION_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                BinaryProtocol.this.sendTextCommand(command);
            }

            public String toString() {
                return "Runnable for " + command;
            }
        });
        try {
            f.get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            this.getLogger().error("timeout sending [" + command + "] giving up: " + e);
            return;
        }
        CommandQueue.getInstance().handleConfirmationMessage("confirmation_" + command);
    }

    public boolean connectAndReadConfiguration(DataListener listener) {
        this.switchToBinaryProtocol();
        this.readImage(16376);
        if (this.isClosed) {
            return false;
        }
        this.startTextPullThread(listener);
        return true;
    }

    private void startTextPullThread(final DataListener listener) {
        if (!LinkManager.COMMUNICATION_QUEUE.isEmpty()) {
            System.out.println("Current queue: " + LinkManager.COMMUNICATION_QUEUE.size());
        }
        Runnable textPull = new Runnable(){

            @Override
            public void run() {
                while (!BinaryProtocol.this.isClosed) {
                    if (LinkManager.COMMUNICATION_QUEUE.isEmpty()) {
                        LinkManager.COMMUNICATION_EXECUTOR.submit(new Runnable(){

                            @Override
                            public void run() {
                                BinaryProtocol.this.requestOutputChannels();
                                String text = BinaryProtocol.this.requestPendingMessages();
                                if (text != null) {
                                    listener.onDataArrived((text + "\r\n").getBytes());
                                }
                            }
                        });
                    }
                    BinaryProtocol.sleep();
                }
                FileLog.MAIN.logLine("Stopping text pull");
            }
        };
        Thread tr = new Thread(textPull);
        tr.setName("text pull");
        tr.start();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void switchToBinaryProtocol() {
        for (int i = 0; i < 15; ++i) {
            this.doSwitchToBinary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSwitchToBinary() {
        long start = System.currentTimeMillis();
        try {
            while (true) {
                if (this.stream.isClosed()) {
                    return;
                }
                this.dropPending();
                this.stream.write("~\n".getBytes());
                Object object = this.ioLock;
                synchronized (object) {
                    boolean isTimeout = this.incomingData.waitForBytes(2, start, "switch to binary");
                    if (isTimeout) {
                        this.logger.info(new Date() + ": Timeout waiting for switch response");
                        this.close();
                        return;
                    }
                    int response = this.incomingData.getShort();
                    if (response == IoHelper.swap16(32266)) {
                        this.logger.info(String.format("Got %x - switched to binary protocol", response));
                        return;
                    }
                    this.logger.error(String.format("Unexpected response [%x], re-trying", response));
                }
            }
        }
        catch (IOException e) {
            this.close();
            FileLog.MAIN.logLine("exception: " + e);
            return;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropPending() throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.incomingData.dropPending();
            this.stream.purge();
        }
    }

    public void uploadChanges(ConfigurationImage newVersion, Logger logger) throws InterruptedException, EOFException, SerialPortException {
        Pair<Integer, Integer> range;
        ConfigurationImage current = this.getController();
        newVersion = newVersion.clone();
        int offset = 0;
        while (offset < current.getSize() && (range = ConfigurationImageDiff.findDifferences(current, newVersion, offset)) != null) {
            int size = (Integer)range.second - (Integer)range.first;
            logger.info("Need to patch: " + range + ", size=" + size);
            byte[] oldBytes = current.getRange((Integer)range.first, size);
            logger.info("old " + Arrays.toString(oldBytes));
            byte[] newBytes = newVersion.getRange((Integer)range.first, size);
            logger.info("new " + Arrays.toString(newBytes));
            this.writeData(newVersion.getContent(), (Integer)range.first, size, logger);
            offset = (Integer)range.second;
        }
        this.burn(logger);
        this.setController(newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receivePacket(String msg, boolean allowLongResponse) throws InterruptedException, EOFException {
        long start = System.currentTimeMillis();
        Object object = this.ioLock;
        synchronized (object) {
            boolean isCrcOk;
            boolean isTimeout = this.incomingData.waitForBytes(2, start, msg + " header");
            if (isTimeout) {
                return null;
            }
            int packetSize = IoHelper.swap16(this.incomingData.getShort());
            this.logger.trace("Got packet size " + packetSize);
            if (packetSize < 0) {
                return null;
            }
            if (!allowLongResponse && packetSize > Math.max(400, 276) + 10) {
                return null;
            }
            isTimeout = this.incomingData.waitForBytes(packetSize + 4, start, msg + " body");
            if (isTimeout) {
                return null;
            }
            byte[] packet = new byte[packetSize];
            this.incomingData.getData(packet);
            int packetCrc = IoHelper.swap32(this.incomingData.getInt());
            int actualCrc = IoHelper.getCrc32(packet);
            boolean bl = isCrcOk = actualCrc == packetCrc;
            if (!isCrcOk) {
                this.logger.trace(String.format("%x", actualCrc) + " vs " + String.format("%x", packetCrc));
                return null;
            }
            this.logger.trace("packet " + Arrays.toString(packet) + ": crc OK");
            return packet;
        }
    }

    public void readImage(int size) {
        ConfigurationImage image = new ConfigurationImage(size);
        int offset = 0;
        long start = System.currentTimeMillis();
        this.logger.info("Reading from controller...");
        while (offset < image.getSize() && System.currentTimeMillis() - start < 60000L) {
            if (this.isClosed) {
                return;
            }
            int remainingSize = image.getSize() - offset;
            int requestSize = Math.min(remainingSize, 400);
            byte[] packet = new byte[7];
            packet[0] = 82;
            IoHelper.putShort(packet, 1, 0);
            IoHelper.putShort(packet, 3, IoHelper.swap16(offset));
            IoHelper.putShort(packet, 5, IoHelper.swap16(requestSize));
            byte[] response = this.executeCommand(packet, "load image offset=" + offset, false);
            if (!IoHelper.checkResponseCode(response, (byte)0) || response.length != requestSize + 1) {
                String code = response == null || response.length == 0 ? "empty" : "code " + response[0];
                String info = response == null ? "null" : code + " size " + response.length;
                this.logger.error("readImage: Something is wrong, retrying... " + info);
                continue;
            }
            ConnectionStatus.INSTANCE.markConnected();
            System.arraycopy(response, 1, image.getContent(), offset, requestSize);
            offset += requestSize;
        }
        this.setController(image);
        this.logger.info("Got configuration from controller.");
        ConnectionStatus.INSTANCE.setValue(ConnectionStatus.Value.CONNECTED);
    }

    private byte[] executeCommand(byte[] packet, String msg, boolean allowLongResponse) {
        if (this.isClosed) {
            return null;
        }
        try {
            this.dropPending();
            this.sendCrcPacket(packet);
            return this.receivePacket(msg, allowLongResponse);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            this.logger.error(msg + ": executeCommand failed: " + e);
            this.close();
            return null;
        }
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.stream.close();
    }

    public void writeData(byte[] content, Integer offset, int size, Logger logger) throws SerialPortException, EOFException, InterruptedException {
        byte[] response;
        if (size > 400) {
            this.writeData(content, offset, 400, logger);
            this.writeData(content, offset + 400, size - 400, logger);
            return;
        }
        this.isBurnPending = true;
        byte[] packet = new byte[7 + size];
        packet[0] = 67;
        IoHelper.putShort(packet, 1, 0);
        IoHelper.putShort(packet, 3, IoHelper.swap16(offset));
        IoHelper.putShort(packet, 5, IoHelper.swap16(size));
        System.arraycopy(content, offset, packet, 7, size);
        long start = System.currentTimeMillis();
        while (!(this.isClosed || System.currentTimeMillis() - start >= 5000L || IoHelper.checkResponseCode(response = this.executeCommand(packet, "writeImage", false), (byte)0) && response.length == 1)) {
            logger.error("writeData: Something is wrong, retrying...");
        }
    }

    private void burn(Logger logger) throws InterruptedException, EOFException, SerialPortException {
        byte[] response;
        if (!this.isBurnPending) {
            return;
        }
        logger.info("Need to burn");
        do {
            if (!this.isClosed) continue;
            return;
        } while (!IoHelper.checkResponseCode(response = this.executeCommand(new byte[]{66}, "burn", false), (byte)4) || response.length != 1);
        logger.info("DONE");
        this.isBurnPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setController(ConfigurationImage controller) {
        Object object = this.imageLock;
        synchronized (object) {
            this.controller = controller.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationImage getController() {
        Object object = this.imageLock;
        synchronized (object) {
            if (this.controller == null) {
                return null;
            }
            return this.controller.clone();
        }
    }

    private void sendCrcPacket(byte[] command) throws IOException {
        BinaryProtocol.sendCrcPacket(command, this.logger, this.stream);
    }

    public static void sendCrcPacket(byte[] command, Logger logger, IoStream stream) throws IOException {
        byte[] packet = IoHelper.makeCrc32Packet(command);
        logger.info("Sending packet " + BinaryProtocol.printHexBinary(command));
        stream.write(packet);
    }

    private static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
            r.append(' ');
        }
        return r.toString();
    }

    private boolean sendTextCommand(String text) {
        byte[] asBytes = text.getBytes();
        byte[] command = new byte[asBytes.length + 1];
        command[0] = 69;
        System.arraycopy(asBytes, 0, command, 1, asBytes.length);
        long start = System.currentTimeMillis();
        while (!this.isClosed && System.currentTimeMillis() - start < 5000L) {
            byte[] response = this.executeCommand(command, "execute", false);
            if (!IoHelper.checkResponseCode(response, (byte)7) || response.length != 1) continue;
            return false;
        }
        return true;
    }

    public String requestPendingMessages() {
        if (this.isClosed) {
            return null;
        }
        try {
            byte[] response = this.executeCommand(new byte[]{71}, "text", true);
            if (response != null && response.length == 1) {
                Thread.sleep(100L);
            }
            return new String(response, 1, response.length - 1);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void requestOutputChannels() {
        if (this.isClosed) {
            return;
        }
        byte[] response = this.executeCommand(new byte[]{79}, "output channels", false);
        if (response == null || response.length != 277 || response[0] != 0) {
            return;
        }
        currentOutputs = response;
        for (Sensor sensor : Sensor.values()) {
            ByteBuffer bb = ByteBuffer.wrap(response, 1 + sensor.getOffset(), 4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            if (sensor.getType() == FieldType.FLOAT) {
                double value = bb.getFloat();
                SensorCentral.getInstance().setValue(value, sensor);
                continue;
            }
            if (sensor.getType() != FieldType.INT) continue;
            int value = bb.getInt();
            SensorCentral.getInstance().setValue(value, sensor);
        }
    }

    static {
        hexCode = "0123456789ABCDEF".toCharArray();
    }
}

