/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.romraider.editor.ecu.ECUEditor;
import com.rusefi.ConfigurationImage;
import com.rusefi.Logger;
import com.rusefi.RomRaiderWrapper;
import com.rusefi.UploadChanges;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.serial.PortHolder;
import java.io.File;
import javax.swing.JOptionPane;
import jssc.SerialPort;

public class BinaryProtocolCmd {
    static BinaryProtocol bp;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Exactly one parameter expected");
            return;
        }
        String port = args[0];
        Logger logger = UploadChanges.logger;
        SerialPort serialPort = new SerialPort(port);
        boolean opened = serialPort.openPort();
        if (!opened) {
            logger.error("failed to open " + port);
        }
        bp = new BinaryProtocol(logger, serialPort);
        PortHolder.setupPort(serialPort, 38400);
        logger.info("Looks good");
        bp.switchToBinaryProtocol();
        bp.readImage(16376);
        BinaryProtocolCmd.doShowImage(bp.getController());
    }

    public static void doShowImage(ConfigurationImage image) throws Exception {
        if (!BinaryProtocolCmd.checkForDefinitionFile()) {
            return;
        }
        RomRaiderWrapper.startRomRaider();
        ECUEditor.openImage(image.getFileContent());
    }

    public static boolean checkForDefinitionFile() {
        if (!new File("rusefi.xml").exists()) {
            JOptionPane.showMessageDialog(null, "rusefi.xml not found, turning off table editor");
            return false;
        }
        return true;
    }

    public static void scheduleUpload(ConfigurationImage newVersion) {
        UploadChanges.scheduleUpload(newVersion, null);
    }
}

