/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.rusefi.Logger;
import etch.util.CircularByteBuffer;
import java.io.EOFException;
import java.util.Arrays;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IncomingDataBuffer {
    private static final int BUFFER_SIZE = 32768;
    private final CircularByteBuffer cbb = new CircularByteBuffer(32768);
    private final Logger logger;

    public IncomingDataBuffer(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(byte[] freshData) {
        this.logger.trace(freshData.length + " byte(s) arrived");
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            if (this.cbb.size() - this.cbb.length() < freshData.length) {
                this.logger.error("IncomingDataBuffer: buffer overflow not expected");
                this.cbb.clear();
            }
            this.cbb.put(freshData);
            this.cbb.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForBytes(int count, long start, String msg) throws InterruptedException {
        this.logger.info("Waiting for " + count + " byte(s): " + msg);
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            while (this.cbb.length() < count) {
                int timeout = (int)(start + 5000L - System.currentTimeMillis());
                if (timeout <= 0) {
                    return true;
                }
                this.cbb.wait(timeout);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropPending() {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            int pending = this.cbb.length();
            if (pending > 0) {
                this.logger.error("Unexpected pending data: " + pending + " byte(s)");
                byte[] bytes = new byte[pending];
                this.cbb.get(bytes);
                this.logger.error("data: " + Arrays.toString(bytes));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShort() throws EOFException {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            return this.cbb.getShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt() throws EOFException {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            return this.cbb.getInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(byte[] packet) {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            this.cbb.get(packet);
        }
    }
}

