/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.config;

import com.rusefi.config.FieldType;
import com.rusefi.core.Pair;
import java.util.HashMap;
import java.util.Map;

public class Field {
    private static final String BIT_VALUE_PREFIX = "bit @";
    private static final String INT_VALUE_PREFIX = "int @";
    private static final String FLOAT_VALUE_PREFIX = "float @";
    public static final int NO_BIT_OFFSET = -1;
    public static final Map<String, Field> VALUES = new HashMap<String, Field>();
    private final String name;
    private final int offset;
    private final FieldType type;
    private final int bitOffset;
    private final String[] options;

    public Field(String name, int offset, FieldType type) {
        this(name, offset, type, -1);
    }

    public Field(String name, int offset, FieldType type, String ... options) {
        this(name, offset, type, -1, options);
    }

    public Field(String name, int offset, FieldType type, int bitOffset) {
        this(name, offset, type, bitOffset, null);
    }

    public Field(String name, int offset, FieldType type, int bitOffset, String[] options) {
        this.name = name;
        this.offset = offset;
        this.type = type;
        this.bitOffset = bitOffset;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public String setCommand() {
        if (this.type == FieldType.BIT) {
            return "set_bit " + this.getOffset() + " " + this.bitOffset;
        }
        return this.getType().getStoreCommand() + " " + this.getOffset();
    }

    public String getCommand() {
        if (this.type == FieldType.BIT) {
            return "get_bit " + this.getOffset() + " " + this.bitOffset;
        }
        return this.type.getLoadCommand() + " " + this.getOffset();
    }

    public int getOffset() {
        return this.offset;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public FieldType getType() {
        return this.type;
    }

    public static boolean isIntValueMessage(String message) {
        return message.startsWith(INT_VALUE_PREFIX);
    }

    public static boolean isBitValueMessage(String message) {
        return message.startsWith(BIT_VALUE_PREFIX);
    }

    public static boolean isFloatValueMessage(String message) {
        return message.startsWith(FLOAT_VALUE_PREFIX);
    }

    public static Pair<Integer, ?> parseResponse(String message) {
        try {
            if (Field.isIntValueMessage(message)) {
                String[] a = (message = message.substring(INT_VALUE_PREFIX.length())).split(" is ");
                if (a.length != 2) {
                    return null;
                }
                int index = Integer.parseInt(a[0]);
                int value = Integer.parseInt(a[1]);
                return new Pair<Integer, Integer>(index, value);
            }
            if (Field.isFloatValueMessage(message)) {
                String[] a = (message = message.substring(FLOAT_VALUE_PREFIX.length())).split(" is ");
                if (a.length != 2) {
                    return null;
                }
                int index = Integer.parseInt(a[0]);
                double value = Double.parseDouble(a[1]);
                return new Pair<Integer, Double>(index, value);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        return "Field{name=" + this.name + "offset=" + this.offset + ", type=" + (Object)((Object)this.type) + '}';
    }

    private static void register(Field field) {
        VALUES.put(field.name, field);
    }

    public static Field create(String name, int offset, FieldType type, int bitOffset) {
        Field field = new Field(name, offset, type, bitOffset);
        Field.register(field);
        return field;
    }

    public static Field create(String name, int offset, FieldType type, String ... options) {
        Field field = new Field(name, offset, type, options);
        Field.register(field);
        return field;
    }

    public static Field create(String name, int offset, FieldType type) {
        Field field = new Field(name, offset, type);
        Field.register(field);
        return field;
    }
}

