/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.FileLog;
import com.rusefi.SensorConversion;
import com.rusefi.core.EngineTimeListener;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Pair;
import com.rusefi.core.ResponseBuffer;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.SensorStats;
import com.rusefi.io.LinkDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class EngineState {
    public static final String SEPARATOR = ",";
    public static final ValueCallback<String> NOTHING = new ValueCallback<String>(){

        @Override
        public void onUpdate(String value) {
        }
    };
    public static final String PACKING_DELIMITER = ":";
    public static final String RUS_EFI_VERSION_TAG = "rusEfiVersion";
    public static final String OUTPIN_TAG = "outpin";
    private static final CharSequence TS_PROTOCOL_TAG = "ts_p_al";
    private final Object lock = new Object();
    public final List<EngineTimeListener> timeListeners = new CopyOnWriteArrayList<EngineTimeListener>();
    private final ResponseBuffer buffer;
    private final List<StringActionPair> actions = new ArrayList<StringActionPair>();
    private final Set<String> keys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public void replaceStringValueAction(String key, ValueCallback<String> callback) {
        this.removeAction(key);
        this.registerStringValueAction(key, callback);
    }

    public EngineState(final @NotNull EngineStateListener listener) {
        this.buffer = new ResponseBuffer(new ResponseBuffer.ResponseListener(){

            @Override
            public void onResponse(String response) {
                if (response != null) {
                    int i = response.indexOf("<EOT>: ");
                    if (i != -1) {
                        response = response.substring(i + "<EOT>: ".length());
                    }
                    String copy = response;
                    listener.beforeLine(response);
                    while (!response.isEmpty()) {
                        response = EngineState.this.handleResponse(response, listener);
                    }
                    listener.afterLine(copy);
                }
            }
        });
        SensorCentral.getInstance().initialize(this);
        SensorStats.start(Sensor.VREF, Sensor.VREF_WIDTH);
        SensorStats.startStandardDeviation(Sensor.DWELL0, Sensor.DWELL0_SD);
        SensorStats.startDelta(Sensor.INJECTOR_1_DWELL, Sensor.INJECTOR_2_DWELL, Sensor.INJ_1_2_DELTA);
        SensorStats.startDelta(Sensor.INJECTOR_3_DWELL, Sensor.INJECTOR_4_DWELL, Sensor.INJ_3_4_DELTA);
        SensorStats.startConversion(Sensor.CLT, Sensor.CLT_F, SensorConversion.C_TO_F);
        SensorStats.startConversion(Sensor.IAT, Sensor.IAT_F, SensorConversion.C_TO_F);
        SensorStats.startConversion(Sensor.MAFR, Sensor.MAFR_CFM, new SensorConversion(){

            @Override
            public double convertValue(double value) {
                return value / 2.081989116;
            }
        });
        this.registerStringValueAction("IAT", NOTHING);
        this.registerStringValueAction("int_temp", NOTHING);
        this.registerStringValueAction("mode", NOTHING);
        this.registerStringValueAction("TPS", NOTHING);
        this.registerStringValueAction("adcfast_co", NOTHING);
        this.registerStringValueAction("adcfast_max", NOTHING);
        this.registerStringValueAction("adcfast_min", NOTHING);
        this.registerStringValueAction("key", NOTHING);
        this.registerStringValueAction("value", NOTHING);
        this.registerStringValueAction("msg", new ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                MessagesCentral.getInstance().postMessage(EngineState.class, value);
            }
        });
        this.registerStringValueAction("advance", NOTHING);
        this.registerStringValueAction("dwell", NOTHING);
        this.registerStringValueAction("offset0", NOTHING);
        this.registerStringValueAction("offset1", NOTHING);
        this.registerStringValueAction("crank_period", NOTHING);
        this.registerStringValueAction("ckp_c", NOTHING);
        this.registerStringValueAction("ev0", NOTHING);
        this.registerStringValueAction("ev1", NOTHING);
        this.registerStringValueAction("adc10", NOTHING);
        this.registerStringValueAction("isC", NOTHING);
        this.registerStringValueAction("p_d", NOTHING);
        this.registerStringValueAction("s_d", NOTHING);
        this.registerStringValueAction("pEC", NOTHING);
        this.registerStringValueAction("sEC", NOTHING);
        this.registerStringValueAction("wEC", NOTHING);
        this.registerStringValueAction("wWi", NOTHING);
        this.registerStringValueAction("wWi2", NOTHING);
        this.registerStringValueAction("cid", NOTHING);
        this.registerStringValueAction("i_d", NOTHING);
        this.registerStringValueAction("i_p", NOTHING);
        this.registerStringValueAction("a_time", NOTHING);
        this.registerStringValueAction("time", new ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                double time;
                try {
                    time = Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    return;
                }
                listener.onTime(time);
                for (EngineTimeListener l : EngineState.this.timeListeners) {
                    l.onTime(time);
                }
            }
        });
    }

    public static String packString(String a) {
        return "line:" + a.length() + PACKING_DELIMITER + a;
    }

    public static String unpackString(String message) {
        int expectedLen;
        String prefix = "line:";
        if (message.contains(TS_PROTOCOL_TAG)) {
            JOptionPane.showMessageDialog(null, "Are you sure you are not connected to TS port?");
            return null;
        }
        if (!message.startsWith(prefix)) {
            FileLog.MAIN.logLine("EngineState: unexpected header: " + message + " while looking for " + prefix);
            return null;
        }
        int delimiterIndex = (message = message.substring(prefix.length())).indexOf(PACKING_DELIMITER);
        if (delimiterIndex == -1) {
            FileLog.MAIN.logLine("Delimiter not found in: " + message);
            return null;
        }
        String lengthToken = message.substring(0, delimiterIndex);
        try {
            expectedLen = Integer.parseInt(lengthToken);
        }
        catch (NumberFormatException e) {
            FileLog.MAIN.logLine("invalid len: " + lengthToken);
            return null;
        }
        String response = message.substring(delimiterIndex + 1);
        if (response.length() != expectedLen) {
            FileLog.MAIN.logLine("message len does not match header: " + message);
            response = null;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleResponse(String response, EngineStateListener listener) {
        String originalResponse = response;
        Object object = this.lock;
        synchronized (object) {
            for (StringActionPair pair : this.actions) {
                response = this.handleStringActionPair(response, pair, listener);
            }
        }
        if (originalResponse.length() == response.length()) {
            FileLog.MAIN.logLine("EngineState.unknown: " + response);
            int keyEnd = response.indexOf(SEPARATOR);
            if (keyEnd == -1) {
                return "";
            }
            String unknownKey = response.substring(0, keyEnd);
            int valueEnd = response.indexOf(SEPARATOR, keyEnd + 1);
            if (valueEnd == -1) {
                return "";
            }
            String value = response.substring(keyEnd, valueEnd);
            FileLog.MAIN.logLine("Invalid key [" + unknownKey + "] value [" + value + "]");
            response = response.substring(valueEnd + SEPARATOR.length());
        }
        return response;
    }

    private String handleStringActionPair(String response, StringActionPair pair, EngineStateListener listener) {
        if (EngineState.startWithIgnoreCase(response, pair.prefix)) {
            String key = (String)pair.first;
            int beginIndex = key.length() + 1;
            int endIndex = response.indexOf(SEPARATOR, beginIndex);
            if (endIndex == -1) {
                endIndex = response.length();
            }
            String strValue = response.substring(beginIndex, endIndex);
            ((ValueCallback)pair.second).onUpdate(strValue);
            listener.onKeyValue(key, strValue);
            response = response.substring(endIndex);
            if (!response.isEmpty()) {
                response = response.substring(1);
            }
            return response;
        }
        return response;
    }

    public static boolean startWithIgnoreCase(String line, String prefix) {
        int pLen = prefix.length();
        if (line.length() < pLen) {
            return false;
        }
        for (int i = 0; i < pLen; ++i) {
            char lineChar = Character.toLowerCase(line.charAt(i));
            char prefixChar = prefix.charAt(i);
            if (Character.isLetter(prefixChar) && !Character.isLowerCase(prefixChar)) {
                throw new IllegalStateException("Not lower: " + prefix);
            }
            if (lineChar == prefixChar) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStringValueAction(String key, ValueCallback<String> callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.keys.contains(key)) {
                throw new IllegalStateException("Already registered: " + key);
            }
            this.keys.add(key);
            this.actions.add(new StringActionPair(key, callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.remove(key);
            Iterator<StringActionPair> it = this.actions.iterator();
            while (it.hasNext()) {
                if (!((String)it.next().first).equals(key)) continue;
                it.remove();
                break;
            }
        }
    }

    public void processNewData(String append, LinkDecoder decoder) {
        this.buffer.append(append, decoder);
    }

    public static class EngineStateListenerImpl
    implements EngineStateListener {
        @Override
        public void beforeLine(String fullLine) {
        }

        @Override
        public void onKeyValue(String key, String value) {
        }

        @Override
        public void afterLine(String fullLine) {
        }

        @Override
        public void onTime(double time) {
        }
    }

    public static interface EngineStateListener
    extends EngineTimeListener {
        public void beforeLine(String var1);

        public void onKeyValue(String var1, String var2);

        public void afterLine(String var1);
    }

    public static interface ValueCallback<V> {
        public static final ValueCallback<?> VOID = new ValueCallback(){

            public void onUpdate(Object value) {
            }
        };

        public void onUpdate(V var1);
    }

    private static class StringActionPair
    extends Pair<String, ValueCallback<String>> {
        public final String prefix;

        StringActionPair(String key, ValueCallback<String> second) {
            super(key, second);
            this.prefix = key.toLowerCase() + EngineState.SEPARATOR;
        }

        @Override
        public String toString() {
            return "Pair(" + (String)this.first + EngineState.SEPARATOR + this.second + "}";
        }
    }
}

