/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.config.FieldType;
import com.rusefi.core.SensorCategory;
import eu.hansolo.steelseries.tools.BackgroundColor;
import java.util.ArrayList;

public enum Sensor {
    MAP("MAP", SensorCategory.SENSOR_INPUTS),
    MAP_RAW("MAP_RAW", SensorCategory.SENSOR_INPUTS),
    BARO("Baro", SensorCategory.SENSOR_INPUTS),
    TIMING("Timing Advance", SensorCategory.OPERATIONS, "deg", -180.0, 180.0),
    CLT("Coolant", SensorCategory.SENSOR_INPUTS, "temperature, C", -40.0, 300.0),
    AFR("A/F ratio", SensorCategory.SENSOR_INPUTS, "", 0.0, 20.0),
    MAF("MAF", SensorCategory.SENSOR_INPUTS, "Volts", 4.0),
    MAFR("MAFR", SensorCategory.SENSOR_INPUTS, "kg/hr", 4.0),
    PPS("pedal", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    knockCount("Knock", SensorCategory.SENSOR_INPUTS, "count", 30.0),
    KnockValue("Knock level", SensorCategory.SENSOR_INPUTS, "v", 6.0),
    ENGINE_LOAD("Engine Load", SensorCategory.SENSOR_INPUTS, "x", 300.0),
    MAFR_CFM("MAFR_CFM", SensorCategory.SENSOR_INPUTS, "cub f/m", 800.0),
    CLT_F("Coolant F", SensorCategory.SENSOR_INPUTS, "temperature, F", -40.0, 500.0),
    IAT_F("Intake Air F", SensorCategory.SENSOR_INPUTS, "temperature, F", -40.0, 350.0),
    ADC0("adc0", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    ADC1("adc1", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    ADC2("adc2", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    ADC3("adc3", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    TRG_0_DUTY("trg0 duty", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    TRG_1_DUTY("trg1 duty", SensorCategory.SENSOR_INPUTS, "%", 100.0),
    TABLE_SPARK("table spark", SensorCategory.OPERATIONS, "ms", -40.0, 40.0),
    VREF("VRef", SensorCategory.SENSOR_INPUTS, "Volts", 6.0),
    VBATT("VBatt", SensorCategory.SENSOR_INPUTS, "Volts", 18.0),
    VREF_WIDTH("VRef w", SensorCategory.OTHERS, "", 1.0),
    DWELL0("Input dwl #1", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    DWELL1("Input dwl #2", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    DWELL2("Input dwl #3", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    DWELL3("Input dwl #4", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    DWELL0_SD("Input d #1", SensorCategory.SNIFFING, "std dev", 100.0),
    TOTAL_DWELL0("Input tdwl #1", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    TOTAL_DWELL1("Input tdwl #2", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    TOTAL_DWELL2("Input tdwl #3", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    TOTAL_DWELL3("Input tdwl #4", SensorCategory.SNIFFING, "ms", 0.0, 30.0, BackgroundColor.BEIGE),
    ADVANCE0("Input Adv #1", SensorCategory.SNIFFING, "deg", -180.0, 180.0, BackgroundColor.BROWN),
    ADVANCE1("Input Adv #2", SensorCategory.SNIFFING, "deg", -180.0, 180.0, BackgroundColor.BROWN),
    ADVANCE2("Input Adv #3", SensorCategory.SNIFFING, "deg", -180.0, 180.0, BackgroundColor.BROWN),
    ADVANCE3("Input Adv #4", SensorCategory.SNIFFING, "deg", -180.0, 180.0, BackgroundColor.BROWN),
    PERIOD0("Period", SensorCategory.SNIFFING, "dg", 0.0, 400.0),
    DUTY0("Duty0", SensorCategory.SNIFFING, "%", 0.0, 100.0, BackgroundColor.RED),
    DUTY1("Duty1", SensorCategory.SNIFFING, "%", 0.0, 100.0, BackgroundColor.RED),
    IDLE_SWITCH("idle switch", SensorCategory.OTHERS),
    DEFAULT_FUEL("map fuel", SensorCategory.FUEL, "ms", 0.0, 40.0),
    CHARTSIZE("CHARTSIZE", SensorCategory.OTHERS),
    CHART_STATUS("CHART_STATUS", SensorCategory.OTHERS),
    ADC_STATUS("ADC_STATUS", SensorCategory.OTHERS),
    ADC_FAST("ADC_FAST", SensorCategory.OTHERS, "b", 4000.0),
    ADC_FAST_AVG("ADC_FAST_AVG", SensorCategory.OTHERS, "b", 4000.0),
    INJECTOR_1_DWELL("inj #1", SensorCategory.SNIFFING),
    INJECTOR_2_DWELL("inj #2", SensorCategory.SNIFFING),
    INJECTOR_3_DWELL("inj #3", SensorCategory.SNIFFING),
    INJECTOR_4_DWELL("inj #4", SensorCategory.SNIFFING),
    FUEL("Fuel", SensorCategory.FUEL, "ms", 0.0, 30.0),
    FUEL_IAT("F IAT", SensorCategory.FUEL, "", 0.0, 10.0),
    FUEL_CLT("F CLT", SensorCategory.FUEL, "", 0.0, 10.0),
    FUEL_LAG("F Lag", SensorCategory.FUEL, "", 0.0, 30.0),
    IAT(SensorCategory.SENSOR_INPUTS, FieldType.FLOAT, 8, BackgroundColor.WHITE, -40.0, 150.0, "C"),
    TPS(SensorCategory.SENSOR_INPUTS, FieldType.FLOAT, 12, BackgroundColor.MUD, 0.0, 100.0, "%"),
    FUEL_BASE(SensorCategory.FUEL, FieldType.FLOAT, 48, BackgroundColor.MUD, 0.0, 30.0, "ms"),
    T_CHARGE(SensorCategory.FUEL, FieldType.FLOAT, 52, BackgroundColor.MUD, 30.0, 140.0),
    ignitionAdvance(SensorCategory.OPERATIONS, FieldType.FLOAT, 56, BackgroundColor.MUD, 30.0, 140.0),
    DWELL(SensorCategory.OPERATIONS, FieldType.FLOAT, 60, BackgroundColor.MUD, 1.0, 10.0),
    actualLastInjection(SensorCategory.FUEL, FieldType.FLOAT, 64, BackgroundColor.MUD, 0.0, 30.0, "ms"),
    debugFloatField1(SensorCategory.OPERATIONS, FieldType.FLOAT, 68, BackgroundColor.MUD, 0.0, 5.0),
    VSS(SensorCategory.OPERATIONS, FieldType.FLOAT, 76, BackgroundColor.BLUE),
    FIRMWARE_VERSION(SensorCategory.OPERATIONS, FieldType.INT, 84, BackgroundColor.BLUE),
    CURRENT_VE(SensorCategory.FUEL, FieldType.FLOAT, 112, BackgroundColor.MUD),
    deltaTps(SensorCategory.FUEL, FieldType.FLOAT, 116, BackgroundColor.MUD),
    engineLoadAccelDelta(SensorCategory.FUEL, FieldType.FLOAT, 124, BackgroundColor.MUD),
    tpsAccelFuel(SensorCategory.FUEL, FieldType.FLOAT, 128, BackgroundColor.MUD),
    Injector_duty(SensorCategory.OPERATIONS, FieldType.FLOAT, 140, BackgroundColor.MUD),
    wallFuelAmount(SensorCategory.FUEL, FieldType.FLOAT, 160, BackgroundColor.MUD),
    iatCorrection(SensorCategory.FUEL, FieldType.FLOAT, 164, BackgroundColor.MUD, 0.0, 5.0),
    wallFuelCorrection(SensorCategory.FUEL, FieldType.FLOAT, 168, BackgroundColor.MUD),
    idlePosition(SensorCategory.OPERATIONS, FieldType.FLOAT, 172, BackgroundColor.MUD),
    TARGET_AFR(SensorCategory.OPERATIONS, FieldType.FLOAT, 176, BackgroundColor.MUD),
    CHARGE_AIR_MASS(SensorCategory.OPERATIONS, FieldType.FLOAT, 180, BackgroundColor.MUD),
    cltCorrection(SensorCategory.OPERATIONS, FieldType.FLOAT, 184, BackgroundColor.MUD, 0.0, 5.0),
    runningFuel(SensorCategory.OPERATIONS, FieldType.FLOAT, 188, BackgroundColor.MUD, 0.0, 15.0, "ms"),
    debugIntField1(SensorCategory.OPERATIONS, FieldType.INT, 192, BackgroundColor.MUD, 0.0, 5.0),
    injectorLagMs(SensorCategory.FUEL, FieldType.FLOAT, 196, BackgroundColor.MUD, 0.0, 15.0, "ms"),
    debugFloatField2(SensorCategory.OPERATIONS, FieldType.FLOAT, 200, BackgroundColor.MUD, 0.0, 5.0),
    debugFloatField3(SensorCategory.OPERATIONS, FieldType.FLOAT, 204, BackgroundColor.MUD, 0.0, 5.0),
    debugFloatField4(SensorCategory.OPERATIONS, FieldType.FLOAT, 208, BackgroundColor.MUD, 0.0, 5.0),
    debugFloatField5(SensorCategory.OPERATIONS, FieldType.FLOAT, 212, BackgroundColor.MUD, 0.0, 5.0),
    debugIntField2(SensorCategory.OPERATIONS, FieldType.INT, 216, BackgroundColor.MUD, 0.0, 5.0),
    debugIntField3(SensorCategory.OPERATIONS, FieldType.INT, 220, BackgroundColor.MUD, 0.0, 5.0),
    warningCounter(SensorCategory.OPERATIONS, FieldType.INT, 236, BackgroundColor.MUD, 0.0, 5.0),
    lastErrorCode(SensorCategory.OPERATIONS, FieldType.INT, 240, BackgroundColor.MUD, 0.0, 5.0),
    RPM(SensorCategory.SENSOR_INPUTS, FieldType.INT, 0, BackgroundColor.RED, 0.0, 8000.0),
    TIME_SECONDS(SensorCategory.OPERATIONS, FieldType.INT, 224, BackgroundColor.MUD, 0.0, 5.0),
    SPEED2RPM(SensorCategory.SENSOR_INPUTS, FieldType.FLOAT, 232, BackgroundColor.MUD, 0.0, 5.0),
    INT_TEMP(SensorCategory.OPERATIONS, FieldType.FLOAT, 244, BackgroundColor.MUD, 0.0, 5.0),
    vvtPosition(SensorCategory.SENSOR_INPUTS, FieldType.FLOAT, 248, BackgroundColor.MUD, 0.0, 5.0),
    engineMode(SensorCategory.OPERATIONS, FieldType.INT, 252, BackgroundColor.MUD, 0.0, 5.0),
    INJ_1_2_DELTA("inj 1-2 delta", SensorCategory.SNIFFING),
    INJ_3_4_DELTA("inj 3-4 delta", SensorCategory.SNIFFING);

    private final String name;
    private final SensorCategory category;
    private final String units;
    private final double minValue;
    private final double maxValue;
    private final BackgroundColor color;
    private final FieldType type;
    private final int offset;

    private Sensor(SensorCategory category, FieldType type, int offset, BackgroundColor color, double minValue, double maxValue, String units) {
        this.name = this.name();
        this.type = type;
        this.offset = offset;
        this.category = category;
        this.color = color;
        this.units = units;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    private Sensor(SensorCategory category, FieldType type, int offset, BackgroundColor color, double minValue, double maxValue) {
        this(category, type, offset, color, minValue, maxValue, "n/a");
    }

    private Sensor(SensorCategory category, FieldType type, int offset, BackgroundColor color) {
        this(category, type, offset, color, 0.0, 100.0);
    }

    private Sensor(String name, SensorCategory category) {
        this(name, category, "", 255.0);
    }

    private Sensor(String name, SensorCategory category, String units, double maxValue) {
        this(name, category, units, 0.0, maxValue);
    }

    private Sensor(String name, SensorCategory category, String units, double minValue, double maxValue) {
        this(name, category, units, minValue, maxValue, BackgroundColor.LIGHT_GRAY);
    }

    private Sensor(String name, SensorCategory category, String units, double minValue, double maxValue, BackgroundColor color) {
        this.name = name;
        this.category = category;
        this.units = units;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.color = color;
        this.type = null;
        this.offset = -1;
    }

    public static ArrayList<Sensor> getSensorsForCategory(String category) {
        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
        for (Sensor sensor : Sensor.values()) {
            if (!sensor.category.getName().equals(category)) continue;
            sensors.add(sensor);
        }
        return sensors;
    }

    public static double processAdvance(double advance) {
        return advance > 360.0 ? advance - 720.0 : advance;
    }

    public static Sensor lookup(String gaugeName, Sensor defaultValue) {
        Sensor sensor;
        try {
            sensor = Sensor.valueOf(Sensor.class, gaugeName);
        }
        catch (IllegalArgumentException e) {
            sensor = defaultValue;
        }
        return sensor;
    }

    public String getName() {
        return this.name;
    }

    public SensorCategory getCategory() {
        return this.category;
    }

    public String getUnits() {
        return this.units;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public BackgroundColor getColor() {
        return this.color;
    }

    public int getOffset() {
        return this.offset;
    }

    public FieldType getType() {
        return this.type;
    }

    public double translateValue(double value) {
        switch (this) {
            case ADVANCE0: 
            case ADVANCE1: 
            case ADVANCE2: 
            case ADVANCE3: 
            case TIMING: {
                return Sensor.processAdvance(value);
            }
        }
        return value;
    }
}

