/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.core.EngineState;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class SensorCentral {
    public static final String RPM_KEY = "rpm";
    private static final SensorCentral INSTANCE = new SensorCentral();
    private final Map<Sensor, Double> values = new EnumMap<Sensor, Double>(Sensor.class);
    private final Map<Sensor, List<SensorListener>> allListeners = new EnumMap<Sensor, List<SensorListener>>(Sensor.class);
    public SensorListener2 anySensorListener;

    public static SensorCentral getInstance() {
        return INSTANCE;
    }

    private SensorCentral() {
    }

    public double getValue(Sensor sensor) {
        Double value = this.values.get((Object)sensor);
        if (value == null) {
            return Double.NaN;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(double value, Sensor sensor) {
        List<SensorListener> listeners;
        Double oldValue = this.values.get((Object)sensor);
        boolean isUpdated = oldValue == null || !oldValue.equals(value);
        this.values.put(sensor, value);
        Map<Sensor, List<SensorListener>> map = this.allListeners;
        synchronized (map) {
            listeners = this.allListeners.get((Object)sensor);
        }
        this.applyValueToTables(value, sensor, isUpdated);
        if (listeners == null) {
            return;
        }
        for (SensorListener listener : listeners) {
            listener.onSensorUpdate(value);
        }
    }

    private void applyValueToTables(double value, Sensor sensor, boolean isUpdated) {
        if (isUpdated && this.anySensorListener != null) {
            this.anySensorListener.onSensorUpdate(sensor, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Sensor sensor, SensorListener listener) {
        List<SensorListener> listeners;
        Map<Sensor, List<SensorListener>> map = this.allListeners;
        synchronized (map) {
            listeners = this.allListeners.get((Object)sensor);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<SensorListener>();
            }
            this.allListeners.put(sensor, listeners);
        }
        listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Sensor sensor, SensorListener listener) {
        List<SensorListener> listeners;
        Map<Sensor, List<SensorListener>> map = this.allListeners;
        synchronized (map) {
            listeners = this.allListeners.get((Object)sensor);
        }
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void initialize(EngineState es) {
        this.addDoubleSensor(RPM_KEY, Sensor.RPM, es);
        this.addDoubleSensor("mat", Sensor.IAT, es);
        this.addDoubleSensor("map", Sensor.MAP, es);
        this.addDoubleSensor("map_r", Sensor.MAP_RAW, es);
        this.addDoubleSensor("baro", Sensor.BARO, es);
        this.addDoubleSensor("clt", Sensor.CLT, es);
        this.addDoubleSensor("tp", Sensor.TPS, es);
        this.addDoubleSensor("pps", Sensor.TPS, es);
        this.addDoubleSensor("error", Sensor.lastErrorCode, es);
        this.addDoubleSensor("warn", Sensor.warningCounter, es);
        this.addDoubleSensor("knck_c", Sensor.knockCount, es);
        this.addDoubleSensor("knck_v", Sensor.KnockValue, es);
        this.addDoubleSensor("target", Sensor.TARGET_AFR, es);
        this.addDoubleSensor(Sensor.VSS, es);
        this.addDoubleSensor(Sensor.ENGINE_LOAD, es);
        this.addDoubleSensor(Sensor.DWELL0, es);
        this.addDoubleSensor(Sensor.DWELL1, es);
        this.addDoubleSensor(Sensor.DWELL2, es);
        this.addDoubleSensor(Sensor.DWELL3, es);
        this.addDoubleSensor(Sensor.TOTAL_DWELL0, es);
        this.addDoubleSensor(Sensor.TOTAL_DWELL1, es);
        this.addDoubleSensor(Sensor.TOTAL_DWELL2, es);
        this.addDoubleSensor(Sensor.TOTAL_DWELL3, es);
        this.addDoubleSensor(Sensor.ADVANCE0, es);
        this.addDoubleSensor(Sensor.ADVANCE1, es);
        this.addDoubleSensor(Sensor.ADVANCE2, es);
        this.addDoubleSensor(Sensor.ADVANCE3, es);
        this.addDoubleSensor(Sensor.knockCount, es);
        this.addDoubleSensor(Sensor.KnockValue, es);
        this.addDoubleSensor("tch", Sensor.T_CHARGE, es);
        this.addDoubleSensor(Sensor.AFR, es);
        this.addDoubleSensor("d_fuel", Sensor.DEFAULT_FUEL, es);
        this.addDoubleSensor(Sensor.FUEL, es);
        this.addDoubleSensor(Sensor.FUEL_BASE, es);
        this.addDoubleSensor(Sensor.FUEL_LAG, es);
        this.addDoubleSensor(Sensor.FUEL_CLT, es);
        this.addDoubleSensor(Sensor.FUEL_IAT, es);
        this.addDoubleSensor(Sensor.TABLE_SPARK, es);
        this.addDoubleSensor(Sensor.VREF, es);
        this.addDoubleSensor(Sensor.VBATT, es);
        this.addDoubleSensor(Sensor.MAF, es);
        this.addDoubleSensor(Sensor.MAFR, es);
        this.addDoubleSensor("period0", Sensor.PERIOD0, es);
        this.addDoubleSensor("period1", Sensor.PERIOD0, es);
        this.addDoubleSensor("duty0", Sensor.DUTY0, es);
        this.addDoubleSensor("duty1", Sensor.DUTY1, es);
        this.addDoubleSensor(Sensor.TIMING, es);
        this.addDoubleSensor(Sensor.TRG_0_DUTY, es);
        this.addDoubleSensor(Sensor.TRG_1_DUTY, es);
        this.addDoubleSensor(Sensor.ADC0, es);
        this.addDoubleSensor(Sensor.ADC1, es);
        this.addDoubleSensor(Sensor.ADC2, es);
        this.addDoubleSensor(Sensor.ADC3, es);
        this.addDoubleSensor("idl", Sensor.IDLE_SWITCH, es);
        this.addDoubleSensor("chart", Sensor.CHART_STATUS, true, es);
        this.addDoubleSensor("chartsize", Sensor.CHARTSIZE, true, es);
        this.addDoubleSensor("adcDebug", Sensor.ADC_STATUS, true, es);
        this.addDoubleSensor("adcfast", Sensor.ADC_FAST, es);
        this.addDoubleSensor("adcfastavg", Sensor.ADC_FAST_AVG, es);
    }

    private void addDoubleSensor(Sensor sensor, EngineState es) {
        this.addDoubleSensor(sensor.name(), sensor, es);
    }

    private void addDoubleSensor(String key, Sensor sensor, EngineState es) {
        this.addDoubleSensor(key, sensor, false, es);
    }

    private void addDoubleSensor(final String key, final Sensor sensor, final boolean verbose, EngineState es) {
        es.registerStringValueAction(key, new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String stringValue) {
                double value;
                try {
                    value = Double.parseDouble(stringValue);
                }
                catch (NumberFormatException e) {
                    return;
                }
                SensorCentral.this.setValue(value, sensor);
                if (verbose) {
                    MessagesCentral.getInstance().postMessage(EngineState.class, key + "=" + value);
                }
            }
        });
    }

    public static interface SensorListener2 {
        public void onSensorUpdate(Sensor var1, double var2);
    }

    public static interface SensorListener {
        public void onSensorUpdate(double var1);
    }
}

