/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.CyclicBuffer;
import com.rusefi.SensorConversion;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;

public class SensorStats {
    public static void start(Sensor source, final Sensor destination) {
        SensorCentral.getInstance().addListener(source, new SensorCentral.SensorListener(){
            int counter;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;

            @Override
            public void onSensorUpdate(double value) {
                ++this.counter;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
                if (this.counter == 10) {
                    this.counter = 0;
                    double width = this.max - this.min;
                    SensorCentral.getInstance().setValue(width, destination);
                    this.min = Double.MAX_VALUE;
                    this.max = Double.MIN_VALUE;
                }
            }
        });
    }

    public static void startStandardDeviation(Sensor source, final Sensor destination) {
        final CyclicBuffer cb = new CyclicBuffer(30);
        SensorCentral.getInstance().addListener(source, new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                cb.add(value);
                if (cb.getSize() == cb.getMaxSize()) {
                    double stdDev = cb.getStandardDeviation();
                    SensorCentral.getInstance().setValue(stdDev, destination);
                }
            }
        });
    }

    public static void startDelta(Sensor input1, final Sensor input2, final Sensor destination) {
        SensorCentral.getInstance().addListener(input1, new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                double valueMs = 1.0 * (value - SensorCentral.getInstance().getValue(input2)) / 100.0;
                SensorCentral.getInstance().setValue(valueMs, destination);
            }
        });
    }

    public static void startConversion(Sensor source, final Sensor destination, final SensorConversion conversion) {
        SensorCentral.getInstance().addListener(source, new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                double converted = conversion.convertValue(value);
                SensorCentral.getInstance().setValue(converted, destination);
            }
        });
    }
}

