/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.test;

import com.rusefi.core.EngineState;
import com.rusefi.io.LinkDecoder;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Test;

public class EngineStateTest {
    @Test
    public void packUnpack() {
        String a = "rpm,100,";
        String packed = EngineState.packString(a);
        Assert.assertEquals((String)"line:8:rpm,100,", (String)packed);
        Assert.assertEquals((String)a, (String)LinkDecoder.TEXT_PROTOCOL_DECODER.unpack(packed));
    }

    @Test
    public void startsWithIgnoreCase() {
        Assert.assertTrue((boolean)EngineState.startWithIgnoreCase("HELLO", "he"));
        Assert.assertFalse((boolean)EngineState.startWithIgnoreCase("HELLO", "hellllll"));
        Assert.assertFalse((boolean)EngineState.startWithIgnoreCase("HELLO", "ha"));
    }

    @Test
    public void testRpm() {
        final AtomicInteger rpmResult = new AtomicInteger();
        EngineState es = new EngineState(new EngineState.EngineStateListenerImpl(){

            @Override
            public void onKeyValue(String key, String value) {
                if ("rpm".equals(key)) {
                    rpmResult.set(Integer.parseInt(value));
                }
            }
        });
        es.processNewData("line:7:", LinkDecoder.TEXT_PROTOCOL_DECODER);
        es.processNewData("rpm,", LinkDecoder.TEXT_PROTOCOL_DECODER);
        Assert.assertEquals((int)0, (int)rpmResult.get());
        es.processNewData("600\r", LinkDecoder.TEXT_PROTOCOL_DECODER);
        Assert.assertEquals((int)600, (int)rpmResult.get());
    }
}

