/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.file;

import com.rusefi.FileLog;
import com.rusefi.core.EngineState;
import com.rusefi.file.FileUtils;
import com.rusefi.models.Point3D;
import com.rusefi.models.XYData;
import java.util.HashMap;
import java.util.Map;

public class BaseMap {
    public static void main(String[] args) {
        BaseMap.loadData("a.csv", "maf", "af");
    }

    public static XYData loadData(String filename, final String key, final String value) {
        FileLog.MAIN.logLine("Loading from " + filename);
        FileLog.MAIN.logLine("Loading " + key + ">" + value);
        final XYData data = new XYData();
        EngineState.EngineStateListenerImpl listener = new EngineState.EngineStateListenerImpl(){
            Map<String, String> values = new HashMap<String, String>();

            @Override
            public void onKeyValue(String key2, String value2) {
                this.values.put(key2, value2);
            }

            @Override
            public void afterLine(String fullLine) {
                if (this.values.containsKey("rpm") && this.values.containsKey(key)) {
                    this.process(this.values);
                }
                this.values.clear();
            }

            private void process(Map<String, String> values) {
                int rpm = (int)Double.parseDouble(values.get("rpm"));
                double k = Double.parseDouble(values.get(key));
                String valueString = values.get(value);
                if (valueString == null) {
                    throw new NullPointerException("No value for: " + value);
                }
                float v = Float.parseFloat(valueString);
                data.addPoint(new Point3D(rpm, k, v));
            }
        };
        EngineState engineState = new EngineState(listener);
        engineState.registerStringValueAction("wave_chart", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
            }
        });
        FileUtils.readFile2(filename, engineState);
        return data;
    }
}

