/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.rusefi.FileLog;
import com.rusefi.core.MessagesCentral;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.io.LinkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class CommandQueue {
    public static final String CONFIRMATION_PREFIX = "confirmation_";
    public static final int DEFAULT_TIMEOUT = 500;
    private static final int COMMAND_CONFIRMATION_TIMEOUT = 1000;
    public static final int SLOW_CONFIRMATION_TIMEOUT = 5000;
    private final Object lock = new Object();
    private Set<String> pendingConfirmations = Collections.synchronizedSet(new HashSet());
    private static final CommandQueue instance = new CommandQueue();
    private final BlockingQueue<MethodInvocation> pendingCommands = new LinkedBlockingQueue<MethodInvocation>();
    private final List<CommandQueueListener> commandListeners = new ArrayList<CommandQueueListener>();
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            MessagesCentral.getInstance().postMessage(CommandQueue.class, "SerialIO started");
            while (true) {
                try {
                    while (true) {
                        CommandQueue.this.sendPendingCommand();
                    }
                }
                catch (Throwable e) {
                    FileLog.MAIN.logException("CommandQueue error", e);
                    System.exit(-2);
                    continue;
                }
                break;
            }
        }
    };

    private static boolean isSlowCommand(String cmd) {
        String lc = cmd.toLowerCase();
        return lc.startsWith("set_engine_type") || lc.startsWith("writeconfig") || lc.startsWith("rewriteconfig");
    }

    public static int getTimeout(String cmd) {
        return CommandQueue.isSlowCommand(cmd) ? 5000 : 1000;
    }

    public void addListener(CommandQueueListener listener) {
        this.commandListeners.add(listener);
    }

    private void sendPendingCommand() throws InterruptedException {
        MethodInvocation command = this.pendingCommands.take();
        this.sendCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(MethodInvocation commandRequest) throws InterruptedException {
        int counter = 0;
        String command = commandRequest.getCommand();
        while (!this.pendingConfirmations.contains(command)) {
            ++counter;
            LinkManager.send(command, commandRequest.fireEvent);
            long now = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(commandRequest.getTimeout());
            }
            long timeWaited = System.currentTimeMillis() - now;
            if (this.pendingConfirmations.contains(command) || timeWaited >= (long)(commandRequest.getTimeout() / 2)) continue;
            long extraWaitTime = (long)(commandRequest.getTimeout() / 2) - timeWaited;
            Thread.sleep(extraWaitTime);
        }
        if (this.pendingConfirmations.contains(command)) {
            commandRequest.listener.onCommandConfirmation();
            this.pendingConfirmations.remove(command);
        }
        if (counter != 1) {
            MessagesCentral.getInstance().postMessage(CommandQueue.class, "Took " + counter + " attempts");
        }
    }

    private CommandQueue() {
        Thread thread = new Thread(this.runnable, "Commands Queue");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConfirmationMessage(String message) {
        MessagesCentral mc = MessagesCentral.getInstance();
        String confirmation = LinkManager.unpackConfirmation(message);
        if (confirmation == null) {
            mc.postMessage(CommandQueue.class, "Broken confirmation length: " + message);
        }
        this.pendingConfirmations.add(confirmation);
        if (LinkManager.LOG_LEVEL.isDebugEnabled()) {
            mc.postMessage(CommandQueue.class, "got valid conf! " + confirmation + ", still pending: " + this.pendingCommands.size());
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static CommandQueue getInstance() {
        return instance;
    }

    public void write(String command) {
        this.write(command, 500);
    }

    public void write(String command, int timeout) {
        this.write(command, timeout, InvocationConfirmationListener.VOID);
    }

    public void write(String command, int timeoutMs, InvocationConfirmationListener listener) {
        this.write(command, timeoutMs, listener, true);
    }

    public void write(String command, int timeoutMs, InvocationConfirmationListener listener, boolean fireEvent) {
        if (fireEvent) {
            for (CommandQueueListener cql : this.commandListeners) {
                cql.onCommand(command);
            }
        }
        this.pendingCommands.add(new MethodInvocation(command, timeoutMs, listener, fireEvent));
    }

    public static interface CommandQueueListener {
        public void onCommand(String var1);
    }

    static class MethodInvocation {
        private final String command;
        private final int timeoutMs;
        private final InvocationConfirmationListener listener;
        private final boolean fireEvent;

        MethodInvocation(String command, int timeoutMs, InvocationConfirmationListener listener, boolean fireEvent) {
            this.command = command;
            this.timeoutMs = timeoutMs;
            this.listener = listener;
            this.fireEvent = fireEvent;
        }

        public String getCommand() {
            return this.command;
        }

        public int getTimeout() {
            return this.timeoutMs;
        }

        public String toString() {
            return "MethodInvocation{timeoutMs=" + this.timeoutMs + ", command='" + this.command + '\'' + '}';
        }
    }
}

