/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.rusefi.core.EngineTimeListener;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.LinkManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class ConnectionStatus {
    private static final String FATAL_MESSAGE_PREFIX = "FATAL";
    @NotNull
    private Value value = Value.NOT_CONNECTED;
    public static ConnectionStatus INSTANCE = new ConnectionStatus();
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Timer timer = new Timer(3000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    });

    private ConnectionStatus() {
        LinkManager.engineState.timeListeners.add(new EngineTimeListener(){

            @Override
            public void onTime(double time) {
                ConnectionStatus.this.markConnected();
            }
        });
        SensorCentral.getInstance().addListener(Sensor.TIME_SECONDS, new SensorCentral.SensorListener(){

            @Override
            public void onSensorUpdate(double value) {
                ConnectionStatus.this.markConnected();
            }
        });
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                if (message.startsWith(ConnectionStatus.FATAL_MESSAGE_PREFIX)) {
                    ConnectionStatus.this.markConnected();
                }
            }
        });
    }

    public void markConnected() {
        if (this.value == Value.NOT_CONNECTED) {
            this.setValue(Value.LOADING);
        }
        this.timer.restart();
    }

    public void setValue(@NotNull Value value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        for (Listener listener : this.listeners) {
            listener.onConnectionStatus(this.isConnected());
        }
    }

    public boolean isConnected() {
        return this.value != Value.NOT_CONNECTED;
    }

    @NotNull
    public Value getValue() {
        return this.value;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void onConnectionStatus(boolean var1);
    }

    public static enum Value {
        NOT_CONNECTED,
        LOADING,
        CONNECTED;

    }
}

