/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.CommunicationLoggingHolder;
import com.rusefi.io.DataListener;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.SerialIoStream;
import com.rusefi.io.serial.SerialManager;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.jetbrains.annotations.Nullable;

public class PortHolder {
    public static int BAUD_RATE = 115200;
    private static PortHolder instance = new PortHolder();
    private final Object portLock = new Object();
    private BinaryProtocol bp;
    @Nullable
    private SerialPort serialPort;

    private PortHolder() {
    }

    boolean openPort(String port, DataListener dataListener, LinkManager.LinkStateListener listener) {
        CommunicationLoggingHolder.communicationLoggingListener.onPortHolderMessage(SerialManager.class, "Opening port: " + port);
        if (port == null) {
            return false;
        }
        boolean result = this.open(port, dataListener);
        if (listener != null) {
            if (result) {
                listener.onConnectionEstablished();
            } else {
                listener.onConnectionFailed();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean open(String port, DataListener listener) {
        SerialPort serialPort = new SerialPort(port);
        try {
            FileLog.MAIN.logLine("Opening " + port + " @ " + BAUD_RATE);
            boolean opened = serialPort.openPort();
            if (!opened) {
                FileLog.MAIN.logLine(port + ": not opened!");
            }
            PortHolder.setupPort(serialPort, BAUD_RATE);
        }
        catch (SerialPortException e) {
            FileLog.MAIN.logLine("ERROR " + e.getMessage());
            return false;
        }
        FileLog.MAIN.logLine("PortHolder: Sleeping a bit");
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        Object object = this.portLock;
        synchronized (object) {
            this.serialPort = serialPort;
            this.portLock.notifyAll();
        }
        this.bp = new BinaryProtocol(FileLog.LOGGER, new SerialIoStream(serialPort, FileLog.LOGGER));
        return this.bp.connectAndReadConfiguration(listener);
    }

    public static void setupPort(SerialPort serialPort, int baudRate) throws SerialPortException {
        serialPort.setRTS(false);
        serialPort.setDTR(false);
        serialPort.setParams(baudRate, 8, 1, 0);
        int mask = 1;
        serialPort.setEventsMask(mask);
        serialPort.setFlowControlMode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.portLock;
        synchronized (object) {
            if (this.serialPort != null) {
                try {
                    this.serialPort.closePort();
                    this.serialPort = null;
                }
                catch (SerialPortException e) {
                    FileLog.MAIN.logLine("Error while closing: " + e);
                }
                finally {
                    this.portLock.notifyAll();
                }
            }
        }
    }

    public void packAndSend(String command, boolean fireEvent) throws InterruptedException {
        if (this.bp == null) {
            throw new NullPointerException("bp");
        }
        this.bp.doSend(command, fireEvent);
    }

    public static PortHolder getInstance() {
        return instance;
    }
}

