/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.rusefi.FileLog;
import com.rusefi.Logger;
import com.rusefi.io.DataListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.serial.SerialPortReader;
import java.io.IOException;
import jssc.SerialPort;
import jssc.SerialPortException;

public class SerialIoStream
implements IoStream {
    private final SerialPort serialPort;
    private final Logger logger;
    private boolean isClosed;

    public SerialIoStream(SerialPort serialPort, Logger logger) {
        this.serialPort = serialPort;
        this.logger = logger;
    }

    @Override
    public void close() {
        this.isClosed = true;
        try {
            FileLog.MAIN.logLine("CLOSING PORT...");
            this.serialPort.closePort();
            FileLog.MAIN.logLine("PORT CLOSED");
        }
        catch (SerialPortException e) {
            this.logger.error("Error closing port: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] bytes) throws IOException {
        try {
            SerialPort serialPort = this.serialPort;
            synchronized (serialPort) {
                this.serialPort.writeBytes(bytes);
            }
        }
        catch (SerialPortException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        try {
            SerialPort serialPort = this.serialPort;
            synchronized (serialPort) {
                this.serialPort.purgePort(12);
            }
        }
        catch (SerialPortException e) {
            this.logger.info("Error while purge: " + e);
            this.close();
        }
    }

    @Override
    public void setDataListener(DataListener listener) {
        try {
            SerialPortReader reader = new SerialPortReader(this.serialPort, listener);
            this.serialPort.addEventListener(reader);
            reader.readInitial();
        }
        catch (SerialPortException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

