/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.rusefi.FileLog;
import com.rusefi.io.DataListener;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.jetbrains.annotations.Nullable;

public class SerialPortReader
implements SerialPortEventListener {
    private static final int[] SLEEP_DURATIONS = new int[]{2, 20, 50, 100};
    private final SerialPort serialPort;
    private DataListener listener;

    public SerialPortReader(final SerialPort serialPort, final DataListener listener) {
        this.serialPort = serialPort;
        this.listener = listener;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (serialPort.isOpened()) {
                        byte[] data = SerialPortReader.progressiveSleepRead(serialPort);
                        if (data == null) continue;
                        listener.onDataArrived(data);
                    }
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
            }
        }, "Reader_" + serialPort).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static byte[] progressiveSleepRead(SerialPort serialPort) throws SerialPortException {
        for (int sleepDuration : SLEEP_DURATIONS) {
            byte[] data;
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                data = serialPort.readBytes();
            }
            if (data != null) {
                return data;
            }
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public void serialEvent(SerialPortEvent spe) {
        if (!spe.isRXCHAR() && !spe.isRXFLAG() && spe.getEventType() != 4) {
            FileLog.MAIN.logLine("less expected SerialPortReader serialEvent " + spe.getEventType());
        }
    }

    public void readInitial() throws SerialPortException {
        int input = this.serialPort.getInputBufferBytesCount();
        FileLog.MAIN.logLine(input + " bytes in input buffer");
        while (this.serialPort.getInputBufferBytesCount() > 0) {
            byte[] data = this.serialPort.readBytes();
            if (data == null) continue;
            this.listener.onDataArrived(data);
        }
    }
}

